/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import javax.inject.Inject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.factory.StorageQualifier;
import org.kie.kogito.persistence.mongodb.MongoServerTestResource;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;
import org.kie.kogito.persistence.mongodb.storage.MongoStorageManager;

@QuarkusTest
@QuarkusTestResource(value=MongoServerTestResource.class)
class MongoStorageManagerIT {
    @Inject
    @StorageQualifier(value="mongodb")
    MongoStorageManager mongoStorageManager;
    Storage storage;

    MongoStorageManagerIT() {
    }

    @AfterEach
    void tearDown() {
        ((MongoStorage)this.storage).mongoCollection.drop();
    }

    @Test
    void testGetCache() {
        String storageName = "testCache";
        this.storage = this.mongoStorageManager.getCache(storageName);
        Assertions.assertTrue((boolean)(this.storage instanceof MongoStorage));
        Assertions.assertEquals((Object)storageName, (Object)((MongoStorage)this.storage).mongoCollection.getNamespace().getCollectionName());
    }

    @Test
    void testGetCacheWithClass() {
        String storageName = "testCacheWithClass";
        this.storage = this.mongoStorageManager.getCache(storageName, String.class);
        Assertions.assertTrue((boolean)(this.storage instanceof MongoStorage));
        Assertions.assertEquals((Object)storageName, (Object)((MongoStorage)this.storage).mongoCollection.getNamespace().getCollectionName());
    }

    @Test
    void getCacheWithDataFormat() {
        String storageName = "testCacheWithDataFormat";
        this.storage = this.mongoStorageManager.getCacheWithDataFormat(storageName, String.class, "type");
        Assertions.assertTrue((boolean)(this.storage instanceof MongoStorage));
        Assertions.assertEquals((Object)storageName, (Object)((MongoStorage)this.storage).mongoCollection.getNamespace().getCollectionName());
    }
}

