/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.storage;

import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import com.mongodb.client.model.changestream.FullDocument;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoObjectListenerException;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class StorageUtils {
    private StorageUtils() {
    }

    public static <V, E> void watchCollection(MongoCollection<E> reactiveMongoCollection, Bson operationType, BiConsumer<String, V> consumer, MongoEntityMapper<V, E> mongoEntityMapper) {
        reactiveMongoCollection.watch(Collections.singletonList(Aggregates.match((Bson)operationType))).fullDocument(FullDocument.UPDATE_LOOKUP).subscribe(new ObjectListenerSubscriber<V, E>(consumer, mongoEntityMapper));
        try {
            TimeUnit.MILLISECONDS.sleep(1500L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    private static class ObjectListenerSubscriber<V, E>
    implements Subscriber<ChangeStreamDocument<Document>> {
        Subscription subscription;
        BiConsumer<String, V> consumer;
        MongoEntityMapper<V, E> mongoEntityMapper;

        ObjectListenerSubscriber(BiConsumer<String, V> consumer, MongoEntityMapper<V, E> mongoEntityMapper) {
            this.consumer = consumer;
            this.mongoEntityMapper = mongoEntityMapper;
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            this.subscription.request(Long.MAX_VALUE);
        }

        public void onNext(ChangeStreamDocument<Document> changeStreamDocument) {
            BsonDocument keyDocument = changeStreamDocument.getDocumentKey();
            Document document = (Document)changeStreamDocument.getFullDocument();
            this.consumer.accept(Optional.ofNullable(keyDocument).map(key -> key.getString((Object)"_id").getValue()).orElse(null), Optional.ofNullable(document).map(doc -> this.mongoEntityMapper.mapToModel(ModelUtils.documentToObject(doc, this.mongoEntityMapper.getEntityClass(), this.mongoEntityMapper::convertToModelAttribute))).orElse(null));
        }

        public void onError(Throwable throwable) {
            this.onComplete();
            throw new MongoObjectListenerException(throwable);
        }

        public void onComplete() {
            if (Objects.nonNull(this.subscription)) {
                this.subscription.cancel();
            }
        }
    }
}

