/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.storage;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.mongodb.MongoServerTestResource;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.mock.MockMongoEntityMapper;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.StorageUtils;

@QuarkusTest
@QuarkusTestResource(value=MongoServerTestResource.class)
class StorageUtilsIT {
    @Inject
    MongoClientManager mongoClientManager;

    StorageUtilsIT() {
    }

    @AfterEach
    void tearDown() {
        MongoCollection collection = this.mongoClientManager.getCollection("test");
        collection.drop();
    }

    @Test
    void testWatchCollection_insert() throws Exception {
        com.mongodb.reactivestreams.client.MongoCollection reactiveMongoCollection = this.mongoClientManager.getReactiveCollection("test");
        MockMongoEntityMapper mongoEntityMapper = new MockMongoEntityMapper();
        TestListener testListenerInsert1 = new TestListener(2);
        StorageUtils.watchCollection((com.mongodb.reactivestreams.client.MongoCollection)reactiveMongoCollection, (Bson)Filters.eq((String)"operationType", (Object)"insert"), (k, v) -> testListenerInsert1.add((String)v), (MongoEntityMapper)mongoEntityMapper);
        TestListener testListenerInsert2 = new TestListener(2);
        StorageUtils.watchCollection((com.mongodb.reactivestreams.client.MongoCollection)reactiveMongoCollection, (Bson)Filters.eq((String)"operationType", (Object)"insert"), (k, v) -> testListenerInsert2.add((String)v), (MongoEntityMapper)mongoEntityMapper);
        MongoCollection mongoCollection = this.mongoClientManager.getCollection("test");
        mongoCollection.insertOne((Object)((Document)mongoEntityMapper.mapToEntity("testKey1", "testValue1")));
        mongoCollection.insertOne((Object)((Document)mongoEntityMapper.mapToEntity("testKey2", "testValue2")));
        testListenerInsert1.await();
        testListenerInsert2.await();
        Assertions.assertEquals((int)2, (int)testListenerInsert1.items.size());
        Assertions.assertTrue((boolean)testListenerInsert1.items.keySet().containsAll(Arrays.asList("testValue1", "testValue2")));
        Assertions.assertEquals((int)2, (int)testListenerInsert2.items.size());
        Assertions.assertTrue((boolean)testListenerInsert2.items.keySet().containsAll(Arrays.asList("testValue1", "testValue2")));
    }

    @Test
    void testWatchCollection_update() throws Exception {
        com.mongodb.reactivestreams.client.MongoCollection mongoReactiveCollection = this.mongoClientManager.getReactiveCollection("test");
        MockMongoEntityMapper mongoEntityMapper = new MockMongoEntityMapper();
        TestListener testListenerUpdate1 = new TestListener(2);
        StorageUtils.watchCollection((com.mongodb.reactivestreams.client.MongoCollection)mongoReactiveCollection, (Bson)Filters.eq((String)"operationType", (Object)"replace"), (k, v) -> testListenerUpdate1.add((String)v), (MongoEntityMapper)mongoEntityMapper);
        TestListener testListenerUpdate2 = new TestListener(2);
        StorageUtils.watchCollection((com.mongodb.reactivestreams.client.MongoCollection)mongoReactiveCollection, (Bson)Filters.eq((String)"operationType", (Object)"replace"), (k, v) -> testListenerUpdate2.add((String)v), (MongoEntityMapper)mongoEntityMapper);
        MongoCollection mongoCollection = this.mongoClientManager.getCollection("test");
        mongoCollection.insertOne((Object)((Document)mongoEntityMapper.mapToEntity("testKey1", "testValue1")));
        mongoCollection.insertOne((Object)((Document)mongoEntityMapper.mapToEntity("testKey2", "testValue2")));
        mongoCollection.replaceOne((Bson)new Document("_id", (Object)"testKey1"), (Object)((Document)mongoEntityMapper.mapToEntity("testKey1", "testValue3")));
        mongoCollection.replaceOne((Bson)new Document("_id", (Object)"testKey2"), (Object)((Document)mongoEntityMapper.mapToEntity("testKey2", "testValue4")));
        testListenerUpdate1.await();
        testListenerUpdate2.await();
        Assertions.assertEquals((int)2, (int)testListenerUpdate1.items.size());
        Assertions.assertTrue((boolean)testListenerUpdate1.items.keySet().containsAll(Arrays.asList("testValue3", "testValue4")));
        Assertions.assertEquals((int)2, (int)testListenerUpdate2.items.size());
        Assertions.assertTrue((boolean)testListenerUpdate2.items.keySet().containsAll(Arrays.asList("testValue3", "testValue4")));
    }

    @Test
    void testWatchCollection_delete() throws Exception {
        com.mongodb.reactivestreams.client.MongoCollection mongoReactiveCollection = this.mongoClientManager.getReactiveCollection("test");
        MockMongoEntityMapper mongoEntityMapper = new MockMongoEntityMapper();
        TestListener testListenerRemove1 = new TestListener(2);
        StorageUtils.watchCollection((com.mongodb.reactivestreams.client.MongoCollection)mongoReactiveCollection, (Bson)Filters.eq((String)"operationType", (Object)"insert"), (k, v) -> testListenerRemove1.add((String)k), (MongoEntityMapper)mongoEntityMapper);
        TestListener testListenerRemove2 = new TestListener(2);
        StorageUtils.watchCollection((com.mongodb.reactivestreams.client.MongoCollection)mongoReactiveCollection, (Bson)Filters.eq((String)"operationType", (Object)"insert"), (k, v) -> testListenerRemove2.add((String)k), (MongoEntityMapper)mongoEntityMapper);
        MongoCollection mongoCollection = this.mongoClientManager.getCollection("test");
        mongoCollection.insertOne((Object)((Document)mongoEntityMapper.mapToEntity("testKey1", "testValue1")));
        mongoCollection.insertOne((Object)((Document)mongoEntityMapper.mapToEntity("testKey2", "testValue2")));
        mongoCollection.deleteOne((Bson)new Document("_id", (Object)"testKey1"));
        mongoCollection.deleteOne((Bson)new Document("_id", (Object)"testKey2"));
        testListenerRemove1.await();
        testListenerRemove2.await();
        Assertions.assertEquals((int)2, (int)testListenerRemove1.items.size());
        Assertions.assertTrue((boolean)testListenerRemove1.items.keySet().containsAll(Arrays.asList("testKey1", "testKey2")));
        Assertions.assertEquals((int)2, (int)testListenerRemove2.items.size());
        Assertions.assertTrue((boolean)testListenerRemove2.items.keySet().containsAll(Arrays.asList("testKey1", "testKey2")));
    }

    static class TestListener {
        volatile Map<String, String> items = new ConcurrentHashMap<String, String>();
        CountDownLatch latch;

        TestListener(int count) {
            this.latch = new CountDownLatch(count);
        }

        void await() throws InterruptedException {
            this.latch.await(10L, TimeUnit.SECONDS);
        }

        void add(String item) {
            this.items.put(item, item);
            this.latch.countDown();
        }
    }
}

