/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.index;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusMock;
import io.quarkus.test.junit.QuarkusTest;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.api.schema.AttributeDescriptor;
import org.kie.kogito.persistence.api.schema.EntityIndexDescriptor;
import org.kie.kogito.persistence.api.schema.IndexDescriptor;
import org.kie.kogito.persistence.api.schema.ProcessDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaRegisteredEvent;
import org.kie.kogito.persistence.api.schema.SchemaRegistrationException;
import org.kie.kogito.persistence.api.schema.SchemaType;
import org.kie.kogito.persistence.mongodb.index.IndexCreateOrUpdateEvent;
import org.kie.kogito.persistence.mongodb.index.IndexManager;
import org.kie.kogito.persistence.mongodb.index.IndexSchemaAcceptor;
import org.kie.kogito.persistence.mongodb.mock.MockProcessIndexEventListener;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class IndexManagerIT {
    private IndexSchemaAcceptor indexSchemaAcceptor;
    @Inject
    MockProcessIndexEventListener mockProcessIndexEventListener;
    @Inject
    IndexManager indexManager;
    List<MongoCollection> collections = new LinkedList<MongoCollection>();
    private static EntityIndexDescriptor travelEntityIndexDescriptor;
    private static EntityIndexDescriptor flightEntityIndexDescriptor;
    private static EntityIndexDescriptor hotelEntityIndexDescriptor;
    private static EntityIndexDescriptor errorEntityIndexDescriptor;

    IndexManagerIT() {
    }

    @BeforeAll
    static void setup_all() {
        AttributeDescriptor flightNumber = new AttributeDescriptor("flightNumber", "string", true);
        IndexDescriptor flightNumberIndex = new IndexDescriptor("flightNumber", List.of("flightNumber"));
        flightEntityIndexDescriptor = new EntityIndexDescriptor("org.acme.travels.travels.Flight", List.of(flightNumberIndex), List.of(flightNumber));
        AttributeDescriptor hotelName = new AttributeDescriptor("name", "string", true);
        AttributeDescriptor hotelRoom = new AttributeDescriptor("room", "string", true);
        IndexDescriptor hotelNameIndex = new IndexDescriptor("name", List.of("name"));
        hotelEntityIndexDescriptor = new EntityIndexDescriptor("org.acme.travels.travels.Hotel", List.of(hotelNameIndex), List.of(hotelName, hotelRoom));
        AttributeDescriptor flight = new AttributeDescriptor("flight", "Flight", false);
        AttributeDescriptor hotel = new AttributeDescriptor("hotel", "org.acme.travels.travels.Hotel", false);
        AttributeDescriptor id = new AttributeDescriptor("id", "string", true);
        AttributeDescriptor metadata = new AttributeDescriptor("metadata", "string", true);
        IndexDescriptor flightIndex = new IndexDescriptor("flight", List.of("flight"));
        IndexDescriptor hotelIndex = new IndexDescriptor("hotel", List.of("hotel"));
        IndexDescriptor idIndex = new IndexDescriptor("id", List.of("id"));
        IndexDescriptor metadataIndex = new IndexDescriptor("metadata", List.of("metadata"));
        travelEntityIndexDescriptor = new EntityIndexDescriptor("org.acme.travels.travels.Travels", List.of(flightIndex, hotelIndex, idIndex, metadataIndex), List.of(flight, hotel, id, metadata));
        errorEntityIndexDescriptor = IndexManagerIT.mockErrorIndexes();
    }

    @BeforeEach
    void setup() {
        this.indexManager.getIndexes().put(flightEntityIndexDescriptor.getName(), flightEntityIndexDescriptor);
        this.indexManager.getIndexes().put(hotelEntityIndexDescriptor.getName(), hotelEntityIndexDescriptor);
        this.indexManager.getIndexes().put(travelEntityIndexDescriptor.getName(), travelEntityIndexDescriptor);
        this.indexSchemaAcceptor = (IndexSchemaAcceptor)Mockito.mock(IndexSchemaAcceptor.class);
        Mockito.when((Object)this.indexSchemaAcceptor.accept((SchemaType)ArgumentMatchers.any())).thenReturn((Object)true);
        QuarkusMock.installMockForType((Object)this.indexSchemaAcceptor, IndexSchemaAcceptor.class, (Annotation[])new Annotation[0]);
        this.mockProcessIndexEventListener.reset();
    }

    @AfterEach
    void tearDown() {
        this.mockProcessIndexEventListener.reset();
        this.indexManager.getCollectionIndexMapping().clear();
        this.indexManager.getIndexes().clear();
        this.collections.forEach(MongoCollection::drop);
        this.collections.clear();
    }

    @Test
    void testOnSchemaRegisteredEvent() {
        HashMap<String, EntityIndexDescriptor> indexes = new HashMap<String, EntityIndexDescriptor>();
        indexes.put("test", travelEntityIndexDescriptor);
        this.indexManager.getCollectionIndexMapping().put("test", travelEntityIndexDescriptor.getName());
        this.indexManager.onSchemaRegisteredEvent(new SchemaRegisteredEvent(new SchemaDescriptor("test", "test", indexes, new ProcessDescriptor("test", travelEntityIndexDescriptor.getName())), new SchemaType("test")));
        MongoCollection testCollection = this.indexManager.getCollection("test");
        this.collections.add(testCollection);
        Set testIndexes = StreamSupport.stream(testCollection.listIndexes().spliterator(), false).map(document -> document.getString((Object)"name")).filter(name -> !"_id_".equals(name)).collect(Collectors.toSet());
        Assertions.assertEquals(this.getTestIndexNames(), testIndexes);
        this.mockProcessIndexEventListener.assertFire("test", travelEntityIndexDescriptor.getName());
    }

    @Test
    void testOnIndexCreateOrUpdateEvent() {
        IndexCreateOrUpdateEvent event = new IndexCreateOrUpdateEvent("test", travelEntityIndexDescriptor.getName());
        this.indexManager.onIndexCreateOrUpdateEvent(event);
        MongoCollection testCollection = this.indexManager.getCollection("test");
        this.collections.add(testCollection);
        Set indexes = StreamSupport.stream(testCollection.listIndexes().spliterator(), false).map(document -> document.getString((Object)"name")).filter(name -> !"_id_".equals(name)).collect(Collectors.toSet());
        Assertions.assertEquals(this.getTestIndexNames(), indexes);
    }

    @Test
    void testUpdateIndexes() {
        this.indexManager.getCollectionIndexMapping().put("test1", travelEntityIndexDescriptor.getName());
        this.indexManager.getCollectionIndexMapping().put("test2", travelEntityIndexDescriptor.getName());
        this.indexManager.updateIndexes(List.of(travelEntityIndexDescriptor, hotelEntityIndexDescriptor, flightEntityIndexDescriptor));
        MongoCollection testCollection1 = this.indexManager.getCollection("test1");
        MongoCollection testCollection2 = this.indexManager.getCollection("test2");
        this.collections.add(testCollection1);
        this.collections.add(testCollection2);
        Set indexes1 = StreamSupport.stream(testCollection1.listIndexes().spliterator(), false).map(document -> document.getString((Object)"name")).filter(name -> !"_id_".equals(name)).collect(Collectors.toSet());
        Assertions.assertEquals(this.getTestIndexNames(), indexes1);
        Set indexes2 = StreamSupport.stream(testCollection2.listIndexes().spliterator(), false).map(document -> document.getString((Object)"name")).filter(name -> !"_id_".equals(name)).collect(Collectors.toSet());
        Assertions.assertEquals(this.getTestIndexNames(), indexes2);
    }

    @Test
    void testUpdateCollection() {
        MongoCollection collection = this.indexManager.getCollection("test");
        this.collections.add(collection);
        collection.createIndex(Indexes.ascending((String[])new String[]{"test"}), new IndexOptions().name("test"));
        this.indexManager.updateCollection(collection, travelEntityIndexDescriptor);
        Set indexes = StreamSupport.stream(collection.listIndexes().spliterator(), false).map(document -> document.getString((Object)"name")).filter(name -> !"_id_".equals(name)).collect(Collectors.toSet());
        Assertions.assertEquals(this.getTestIndexNames(), indexes);
    }

    @Test
    void testUpdateCollectionTooManyIndexes() {
        MongoCollection collection = this.indexManager.getCollection("test");
        this.collections.add(collection);
        collection.createIndex(Indexes.ascending((String[])new String[]{"test"}), new IndexOptions().name("test"));
        try {
            this.indexManager.updateCollection(collection, errorEntityIndexDescriptor);
            Assertions.fail((String)"Exception for creating too many indexes was not thrown");
        }
        catch (SchemaRegistrationException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("no more than 64 indexes"));
        }
    }

    @Test
    void testCreateIndexForEntity() {
        List indexes = this.indexManager.createIndexForEntity("", travelEntityIndexDescriptor);
        Assertions.assertTrue((boolean)this.equalsIndexModels(indexes, this.getTestIndexModels()));
    }

    @Test
    void testCreateSingleIndex() {
        String fieldName = "id";
        IndexDescriptor id = new IndexDescriptor(fieldName, List.of(fieldName));
        String parentField = "";
        String prefixUUID = UUID.randomUUID().toString() + ".";
        Optional index = this.indexManager.createIndex(id, parentField, prefixUUID);
        Assertions.assertTrue((boolean)this.equalsIndexModels(List.of((IndexModel)index.get()), List.of(new IndexModel(Indexes.ascending((String[])new String[]{fieldName}), new IndexOptions().name(prefixUUID + fieldName).sparse(true)))));
    }

    @Test
    void testCreateNoIndex() {
        String fieldName = "id";
        IndexDescriptor id = new IndexDescriptor(fieldName, List.of());
        String parentField = "";
        String prefixUUID = UUID.randomUUID().toString() + ".";
        Optional index = this.indexManager.createIndex(id, parentField, prefixUUID);
        Assertions.assertFalse((boolean)index.isPresent());
    }

    @Test
    void testCreateCompoundIndex() {
        String indexName = "test";
        IndexDescriptor id = new IndexDescriptor(indexName, List.of("test1", "test2"));
        String parentField = "test";
        String prefixUUID = UUID.randomUUID().toString() + ".";
        Optional index = this.indexManager.createIndex(id, parentField, prefixUUID);
        Assertions.assertTrue((boolean)this.equalsIndexModels(List.of((IndexModel)index.get()), List.of(new IndexModel(Indexes.ascending((String[])new String[]{indexName + ".test1", indexName + ".test2"}), new IndexOptions().name(prefixUUID + indexName).sparse(true)))));
    }

    @Test
    void testGetCollectionsWithIndex() {
        this.indexManager.getCollectionIndexMapping().put("collection1", "index1");
        this.indexManager.getCollectionIndexMapping().put("collection2", "index1");
        this.indexManager.getCollectionIndexMapping().put("collection3", "index1");
        this.indexManager.getCollectionIndexMapping().put("collection4", "index2");
        this.indexManager.getCollectionIndexMapping().put("collection5", "index2");
        List index1Collections = this.indexManager.getCollectionsWithIndex("index1");
        List index2Collections = this.indexManager.getCollectionsWithIndex("index2");
        List index3Collections = this.indexManager.getCollectionsWithIndex("index3");
        HashSet<String> expectedIndex1Collections = new HashSet<String>();
        expectedIndex1Collections.add("collection1");
        expectedIndex1Collections.add("collection2");
        expectedIndex1Collections.add("collection3");
        HashSet<String> expectedIndex2Collections = new HashSet<String>();
        expectedIndex2Collections.add("collection4");
        expectedIndex2Collections.add("collection5");
        Assertions.assertEquals(expectedIndex1Collections, new HashSet(index1Collections));
        Assertions.assertEquals(expectedIndex2Collections, new HashSet(index2Collections));
        Assertions.assertTrue((boolean)index3Collections.isEmpty());
    }

    private List<IndexModel> getTestIndexModels() {
        return List.of(new IndexModel(Indexes.ascending((String[])new String[]{"flight"}), new IndexOptions().name("d41d8cd9-8f00-3204-a980-0998ecf8427e.flight").sparse(true)), new IndexModel(Indexes.ascending((String[])new String[]{"flight.flightNumber"}), new IndexOptions().name("e325b16a-a10b-32b0-a574-2595902073cb.flightNumber").sparse(true)), new IndexModel(Indexes.ascending((String[])new String[]{"hotel"}), new IndexOptions().name("d41d8cd9-8f00-3204-a980-0998ecf8427e.hotel").sparse(true)), new IndexModel(Indexes.ascending((String[])new String[]{"hotel.name"}), new IndexOptions().name("e919c49d-5f0c-3737-a853-67810a3394d0.name").sparse(true)), new IndexModel(Indexes.ascending((String[])new String[]{"id"}), new IndexOptions().name("d41d8cd9-8f00-3204-a980-0998ecf8427e.id").sparse(true)), new IndexModel(Indexes.ascending((String[])new String[]{"metadata"}), new IndexOptions().name("d41d8cd9-8f00-3204-a980-0998ecf8427e.metadata").sparse(true)));
    }

    private Set<String> getTestIndexNames() {
        return this.getTestIndexModels().stream().map(indexModel -> indexModel.getOptions().getName()).collect(Collectors.toSet());
    }

    private boolean equalsIndexModels(List<IndexModel> indexModels1, List<IndexModel> indexModels2) {
        HashMap indexModelMapping1 = new HashMap();
        indexModels1.forEach(indexModel -> indexModelMapping1.put(indexModel.getOptions().getName(), indexModel.getKeys()));
        HashMap indexModelMapping2 = new HashMap();
        indexModels2.forEach(indexModel -> indexModelMapping2.put(indexModel.getOptions().getName(), indexModel.getKeys()));
        return indexModelMapping1.equals(indexModelMapping2);
    }

    private static EntityIndexDescriptor mockErrorIndexes() {
        List indexDescriptors = IntStream.rangeClosed(0, 75).mapToObj(i -> new IndexDescriptor("test" + i, List.of("test" + i))).collect(Collectors.toList());
        List attributeDescriptors = IntStream.rangeClosed(0, 75).mapToObj(i -> new AttributeDescriptor("test" + i, "string", true)).collect(Collectors.toList());
        return new EntityIndexDescriptor("org.acme.travels.travels.Travels", indexDescriptors, attributeDescriptors);
    }
}

