/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Optional;
import org.bson.Document;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.mongodb.mock.MockMongoEntityMapper;
import org.kie.kogito.persistence.mongodb.model.ModelUtils;

class ModelUtilsTest {
    ModelUtilsTest() {
    }

    @Test
    void testInstantToZonedDateTime() {
        ZonedDateTime time = ZonedDateTime.now();
        Assertions.assertEquals((long)time.toInstant().toEpochMilli(), (long)ModelUtils.instantToZonedDateTime((Long)time.toInstant().toEpochMilli()).toInstant().toEpochMilli());
    }

    @Test
    void testZonedDateTimeToInstant() {
        ZonedDateTime time = ZonedDateTime.now();
        Assertions.assertEquals((long)time.toInstant().toEpochMilli(), (Long)ModelUtils.zonedDateTimeToInstant((ZonedDateTime)time));
    }

    @Test
    void testDocumentToJsonNode() {
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("testKey1", "testValue1");
        objectMap.put("testKey2", "testValue2");
        ObjectNode object = (ObjectNode)ModelUtils.MAPPER.valueToTree(objectMap);
        Document document = new Document().append("testKey1", (Object)"testValue1").append("testKey2", (Object)"testValue2");
        Assertions.assertEquals((Object)object, (Object)ModelUtils.documentToJsonNode((Document)document, ObjectNode.class));
    }

    @Test
    void testJsonNodeToDocument() {
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("testKey1", "testValue1");
        objectMap.put("testKey2", "testValue2");
        ObjectNode object = (ObjectNode)ModelUtils.MAPPER.valueToTree(objectMap);
        Document document = new Document().append("testKey1", (Object)"testValue1").append("testKey2", (Object)"testValue2");
        Assertions.assertEquals((Object)document, (Object)ModelUtils.jsonNodeToDocument((JsonNode)object));
    }

    @Test
    void testDocumentToObject() {
        HashMap<String, String> objectMap = new HashMap<String, String>();
        objectMap.put("id", "testId");
        objectMap.put("testKey1", "testValue1");
        objectMap.put("testKey2", "testValue2");
        Document document = new Document().append("_id", (Object)"testId").append("testKey1", (Object)"testValue1").append("testKey2", (Object)"testValue2");
        Assertions.assertEquals(objectMap, (Object)ModelUtils.documentToObject((Document)document, HashMap.class, arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToModelAttribute(arg_0)));
    }

    @Test
    void testConvertAttributes() {
        HashMap<String, String> subMap = new HashMap<String, String>();
        subMap.put("subTestKey1", "subTestValue1");
        subMap.put("subTestKey2", "subTestValue2");
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("_id", "testId");
        objectMap.put("testKey1", "testValue1");
        objectMap.put("testKey2", "testValue2");
        objectMap.put("subMapKey", subMap);
        ObjectNode object = (ObjectNode)ModelUtils.MAPPER.valueToTree(objectMap);
        HashMap<String, Object> expectedMap = new HashMap<String, Object>();
        expectedMap.put("id", "testId");
        expectedMap.put("testKey1", "testValue1");
        expectedMap.put("testKey2", "testValue2");
        expectedMap.put("subMapKey", subMap);
        ObjectNode expected = (ObjectNode)ModelUtils.MAPPER.valueToTree(expectedMap);
        Assertions.assertEquals((Object)expected, (Object)ModelUtils.convertAttributes((ObjectNode)object, Optional.empty(), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToModelAttribute(arg_0)));
    }
}

