/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.query;

import com.mongodb.client.MongoCollection;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.List;
import javax.inject.Inject;
import org.bson.Document;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.mock.MockMongoEntityMapper;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.query.MongoQuery;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class MongoQueryIT {
    @Inject
    MongoClientManager mongoClientManager;
    MongoQuery<String, Document> mongoQuery;
    MongoCollection<Document> collection;

    MongoQueryIT() {
    }

    @BeforeEach
    void setup() {
        this.collection = this.mongoClientManager.getCollection("test", Document.class);
        this.mongoQuery = new MongoQuery(this.collection, (MongoEntityMapper)new MockMongoEntityMapper());
    }

    @AfterEach
    void tearDown() {
        this.collection.drop();
    }

    @Test
    void testExecute() {
        this.collection.insertOne((Object)new Document("_id", (Object)"1").append("test_attribute", (Object)"2"));
        this.collection.insertOne((Object)new Document("_id", (Object)"2").append("test_attribute", (Object)"5"));
        this.collection.insertOne((Object)new Document("_id", (Object)"3").append("test_attribute", (Object)"7"));
        this.collection.insertOne((Object)new Document("_id", (Object)"4").append("test_attribute", (Object)"10"));
        this.collection.insertOne((Object)new Document("_id", (Object)"5").append("test_attribute", (Object)"11"));
        this.mongoQuery.limit(Integer.valueOf(1));
        this.mongoQuery.offset(Integer.valueOf(1));
        this.mongoQuery.sort(List.of(QueryFilterFactory.orderBy((String)"test_attribute", (SortDirection)SortDirection.ASC)));
        this.mongoQuery.filter(List.of(QueryFilterFactory.in((String)"test_attribute", List.of("2", "5", "7"))));
        List results = this.mongoQuery.execute();
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertEquals((Object)"5", results.get(0));
    }
}

