/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.query;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.QueryFilterFactory;
import org.kie.kogito.persistence.mongodb.mock.MockMongoEntityMapper;
import org.kie.kogito.persistence.mongodb.query.QueryUtils;

class QueryUtilsTest {
    QueryUtilsTest() {
    }

    @Test
    void testGenerateQuery() {
        Optional result = QueryUtils.generateQuery(List.of(QueryFilterFactory.contains((String)"test", (String)"testValue")), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertTrue((boolean)result.isPresent());
        Assertions.assertEquals((Object)Filters.and((Iterable)Stream.of(Filters.eq((String)"test", (Object)"testValue")).collect(Collectors.toList())), result.get());
    }

    @Test
    void testGenerateSingleQuery_contains() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.contains((String)"test", (String)"testValue"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.eq((String)"test", (Object)"testValue"), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_equalTo() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.equalTo((String)"test", (Object)"testValue"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.eq((String)"test", (Object)"testValue"), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_like() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.like((String)"test", (String)"testValue"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.regex((String)"test", (String)"testValue"), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_isNull() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.isNull((String)"test"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.exists((String)"test", (boolean)false), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_notNull() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.notNull((String)"test"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.exists((String)"test", (boolean)true), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_greaterThan() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.greaterThan((String)"test", (Object)"testValue"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.gt((String)"test", (Object)"testValue"), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_greatThanEqual() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.greaterThanEqual((String)"test", (Object)"testValue"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.gte((String)"test", (Object)"testValue"), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_lessThan() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.lessThan((String)"test", (Object)"testValue"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.lt((String)"test", (Object)"testValue"), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_lessThanEqual() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.lessThanEqual((String)"test", (Object)"testValue"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.lte((String)"test", (Object)"testValue"), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_between() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.between((String)"test", (Object)"testValue1", (Object)"testValue2"), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.and((Bson[])new Bson[]{Filters.gte((String)"test", (Object)"testValue1"), Filters.lte((String)"test", (Object)"testValue2")}), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_in() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.in((String)"test", List.of("testValue")), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.in((String)"test", List.of("testValue")), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_containsAll() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.containsAll((String)"test", List.of("testValue")), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.all((String)"test", List.of("testValue")), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_containsAny() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.containsAny((String)"test", List.of("testValue")), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.or((Bson[])new Bson[]{Filters.eq((String)"test", (Object)"testValue")}), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_or() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.or(List.of(QueryFilterFactory.contains((String)"test", (String)"testValue"))), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.or((Bson[])new Bson[]{Filters.eq((String)"test", (Object)"testValue")}), (Object)result);
    }

    @Test
    void testGenerateSingleQuery_and() {
        Bson result = QueryUtils.generateSingleQuery((AttributeFilter)QueryFilterFactory.and(List.of(QueryFilterFactory.contains((String)"test", (String)"testValue"))), arg_0 -> ((MockMongoEntityMapper)new MockMongoEntityMapper()).convertToMongoAttribute(arg_0));
        Assertions.assertEquals((Object)Filters.and((Bson[])new Bson[]{Filters.eq((String)"test", (Object)"testValue")}), (Object)result);
    }
}

