/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.storage;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Objects;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.mock.MockMongoEntityMapper;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.storage.MongoStorage;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class MongoStorageIT {
    @Inject
    MongoClientManager mongoClientManager;
    MongoStorage<String, Document> storage;
    MongoCollection<Document> collection;

    MongoStorageIT() {
    }

    @BeforeEach
    void setup() {
        this.collection = this.mongoClientManager.getCollection("test", Document.class);
        this.storage = new MongoStorage(this.collection, this.mongoClientManager.getReactiveCollection("test", Document.class), String.class.getName(), (MongoEntityMapper)new MockMongoEntityMapper());
    }

    @AfterEach
    void tearDown() {
        this.collection.drop();
    }

    @Test
    void testContainsKey() {
        String testId = "testContains";
        this.collection.insertOne((Object)new Document("_id", (Object)testId));
        Assertions.assertTrue((boolean)this.storage.containsKey(testId));
    }

    @Test
    void testGet() {
        String testId = "testGet";
        String testValue = "testValue";
        this.collection.insertOne((Object)new Document("_id", (Object)testId).append("test_attribute", (Object)testValue));
        Assertions.assertEquals((Object)testValue, (Object)this.storage.get(testId));
    }

    @Test
    void testPut() {
        String testId = "testPut";
        String testValue = "testValue";
        this.storage.put(testId, (Object)testValue);
        FindIterable findIterable = this.collection.find((Bson)new Document("_id", (Object)testId));
        Document document = (Document)findIterable.first();
        Assertions.assertTrue((boolean)Objects.nonNull(document));
        Assertions.assertEquals((Object)testValue, (Object)document.get((Object)"test_attribute"));
    }

    @Test
    void testClear() {
        String testId = "testClear";
        String testValue = "testValue";
        this.collection.insertOne((Object)new Document("_id", (Object)testId).append("test_attribute", (Object)testValue));
        this.storage.clear();
        FindIterable findIterable = this.collection.find();
        Assertions.assertFalse((boolean)findIterable.iterator().hasNext());
    }

    @Test
    void testRemove() {
        String testId = "testRemove";
        String testValue = "testValue";
        this.collection.insertOne((Object)new Document("_id", (Object)testId).append("test_attribute", (Object)testValue));
        this.storage.remove(testId);
        FindIterable findIterable = this.collection.find((Bson)new Document("_id", (Object)testId));
        Assertions.assertFalse((boolean)findIterable.iterator().hasNext());
    }
}

