/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.storage;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import java.util.Arrays;
import javax.inject.Inject;
import org.bson.Document;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.persistence.api.factory.StorageQualifier;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.storage.StorageUtilsIT;
import org.kie.kogito.testcontainers.quarkus.MongoDBQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=MongoDBQuarkusTestResource.class)
class StorageListenerIT {
    @Inject
    MongoClientManager mongoClientManager;
    @Inject
    @StorageQualifier(value="mongodb")
    StorageService storageService;

    StorageListenerIT() {
    }

    @BeforeEach
    void setup() {
        this.mongoClientManager.getCollection("test", Document.class).insertOne((Object)new Document("test", (Object)"test"));
    }

    @AfterEach
    void tearDown() {
        this.mongoClientManager.getCollection("test", Document.class).drop();
    }

    @Test
    void testObjectCreatedListener() throws Exception {
        StorageUtilsIT.TestListener testListener = new StorageUtilsIT.TestListener(3);
        Storage storage = this.storageService.getCache("test");
        storage.addObjectCreatedListener(testListener::add);
        storage.put((Object)"testKey_insert_1", (Object)"testValue1");
        storage.put((Object)"testKey_insert_2", (Object)"testValue2");
        storage.put((Object)"testKey_insert_3", (Object)"testValue3");
        testListener.await();
        Assertions.assertEquals((int)3, (int)testListener.items.size(), (String)("values: " + testListener.items.keySet()));
        Assertions.assertTrue((boolean)testListener.items.keySet().containsAll(Arrays.asList("testValue1", "testValue2", "testValue3")));
    }

    @Test
    void testObjectUpdatedListener() throws Exception {
        StorageUtilsIT.TestListener testListener = new StorageUtilsIT.TestListener(2);
        Storage cache = this.storageService.getCache("test");
        cache.addObjectUpdatedListener(testListener::add);
        cache.put((Object)"testKey_update_1", (Object)"testValue1");
        cache.put((Object)"testKey_update_1", (Object)"testValue2");
        cache.put((Object)"testKey_update_2", (Object)"testValue3");
        cache.put((Object)"testKey_update_2", (Object)"testValue4");
        testListener.await();
        Assertions.assertEquals((int)2, (int)testListener.items.size());
        Assertions.assertTrue((boolean)testListener.items.keySet().containsAll(Arrays.asList("testValue2", "testValue4")));
    }

    @Test
    void testObjectRemovedListener() throws Exception {
        StorageUtilsIT.TestListener testListener = new StorageUtilsIT.TestListener(2);
        Storage cache = this.storageService.getCache("test");
        cache.addObjectRemovedListener(testListener::add);
        cache.put((Object)"testKey_remove_1", (Object)"testValue1");
        cache.put((Object)"testKey_remove_2", (Object)"testValue2");
        cache.remove((Object)"testKey_remove_1");
        cache.remove((Object)"testKey_remove_2");
        testListener.await();
        Assertions.assertEquals((int)2, (int)testListener.items.size());
        Assertions.assertTrue((boolean)testListener.items.keySet().containsAll(Arrays.asList("testKey_remove_1", "testKey_remove_2")));
    }
}

