/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.query;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Sorts;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.kie.kogito.persistence.api.query.AttributeFilter;
import org.kie.kogito.persistence.api.query.AttributeSort;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.api.query.SortDirection;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.query.QueryUtils;

public class MongoQuery<V, E>
implements Query<V> {
    Integer limit;
    Integer offset;
    List<AttributeFilter<?>> filters;
    List<AttributeSort> sortBy;
    MongoEntityMapper<V, E> mongoEntityMapper;
    MongoCollection<E> mongoCollection;

    public MongoQuery(MongoCollection<E> mongoCollection, MongoEntityMapper<V, E> mongoEntityMapper) {
        this.mongoCollection = mongoCollection;
        this.mongoEntityMapper = mongoEntityMapper;
    }

    public Query<V> limit(Integer limit) {
        this.limit = limit;
        return this;
    }

    public Query<V> offset(Integer offset) {
        this.offset = offset;
        return this;
    }

    public Query<V> filter(List<AttributeFilter<?>> filters) {
        this.filters = filters;
        return this;
    }

    public Query<V> sort(List<AttributeSort> sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    public List<V> execute() {
        MongoCollection<E> collection = this.mongoCollection;
        Optional<Bson> query = QueryUtils.generateQuery(this.filters, this.mongoEntityMapper::convertToMongoAttribute);
        Optional<Bson> sort = this.generateSort();
        FindIterable find = query.map(arg_0 -> collection.find(arg_0)).orElseGet(() -> collection.find());
        find = sort.map(arg_0 -> ((FindIterable)find).sort(arg_0)).orElse(find);
        find = Optional.ofNullable(this.offset).map(arg_0 -> ((FindIterable)find).skip(arg_0)).orElse(find);
        find = Optional.ofNullable(this.limit).map(arg_0 -> ((FindIterable)find).limit(arg_0)).orElse(find);
        LinkedList<V> list = new LinkedList<V>();
        try (MongoCursor cursor = find.iterator();){
            while (cursor.hasNext()) {
                Object e = cursor.next();
                list.add(this.mongoEntityMapper.mapToModel(e));
            }
        }
        return list;
    }

    private Optional<Bson> generateSort() {
        return Optional.ofNullable(this.sortBy).map(sbList -> Sorts.orderBy(sbList.stream().map(sb -> SortDirection.ASC.equals((Object)sb.getSort()) ? Sorts.ascending((String[])new String[]{this.mongoEntityMapper.convertToMongoAttribute(sb.getAttribute())}) : Sorts.descending((String[])new String[]{this.mongoEntityMapper.convertToMongoAttribute(sb.getAttribute())})).collect(Collectors.toList())));
    }
}

