/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.query;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.kie.kogito.persistence.api.query.AttributeFilter;

public class QueryUtils {
    private QueryUtils() {
    }

    static Optional<Bson> generateQuery(List<AttributeFilter<?>> filters, UnaryOperator<String> filterFunction) {
        return Optional.ofNullable(filters).filter(f -> !f.isEmpty()).map(fs -> Filters.and((Iterable)fs.stream().map(f -> QueryUtils.generateSingleQuery(f, filterFunction)).collect(Collectors.toList())));
    }

    static Bson generateSingleQuery(AttributeFilter<?> filter, UnaryOperator<String> filterFunction) {
        switch (filter.getCondition()) {
            case CONTAINS: 
            case EQUAL: {
                return Filters.eq((String)((String)filterFunction.apply(filter.getAttribute())), (Object)filter.getValue());
            }
            case LIKE: {
                return Filters.regex((String)((String)filterFunction.apply(filter.getAttribute())), (String)((String)filter.getValue()).replace("*", ".*"));
            }
            case IS_NULL: {
                return Filters.exists((String)((String)filterFunction.apply(filter.getAttribute())), (boolean)false);
            }
            case NOT_NULL: {
                return Filters.exists((String)((String)filterFunction.apply(filter.getAttribute())), (boolean)true);
            }
            case GT: {
                return Filters.gt((String)((String)filterFunction.apply(filter.getAttribute())), (Object)filter.getValue());
            }
            case GTE: {
                return Filters.gte((String)((String)filterFunction.apply(filter.getAttribute())), (Object)filter.getValue());
            }
            case LT: {
                return Filters.lt((String)((String)filterFunction.apply(filter.getAttribute())), (Object)filter.getValue());
            }
            case LTE: {
                return Filters.lte((String)((String)filterFunction.apply(filter.getAttribute())), (Object)filter.getValue());
            }
            case BETWEEN: {
                List value = (List)filter.getValue();
                return Filters.and((Bson[])new Bson[]{Filters.gte((String)((String)filterFunction.apply(filter.getAttribute())), value.get(0)), Filters.lte((String)((String)filterFunction.apply(filter.getAttribute())), value.get(1))});
            }
            case IN: {
                return Filters.in((String)((String)filterFunction.apply(filter.getAttribute())), (Iterable)((List)filter.getValue()));
            }
            case CONTAINS_ALL: {
                return Filters.all((String)((String)filterFunction.apply(filter.getAttribute())), (Iterable)((List)filter.getValue()));
            }
            case CONTAINS_ANY: {
                return Filters.or((Iterable)((List)filter.getValue()).stream().map(v -> Filters.eq((String)((String)filterFunction.apply(filter.getAttribute())), (Object)v)).collect(Collectors.toList()));
            }
            case OR: {
                return Filters.or((Iterable)((List)filter.getValue()).stream().map(f -> QueryUtils.generateSingleQuery(f, filterFunction)).collect(Collectors.toList()));
            }
            case AND: {
                return Filters.and((Iterable)((List)filter.getValue()).stream().map(f -> QueryUtils.generateSingleQuery(f, filterFunction)).collect(Collectors.toList()));
            }
            case NOT: {
                return Filters.not((Bson)QueryUtils.generateSingleQuery((AttributeFilter)filter.getValue(), filterFunction));
            }
        }
        return null;
    }
}

