/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.index;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.bson.Document;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.persistence.api.schema.EntityIndexDescriptor;
import org.kie.kogito.persistence.api.schema.IndexDescriptor;
import org.kie.kogito.persistence.api.schema.ProcessDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaRegisteredEvent;
import org.kie.kogito.persistence.api.schema.SchemaRegistrationException;
import org.kie.kogito.persistence.mongodb.client.MongoClientManager;
import org.kie.kogito.persistence.mongodb.index.IndexCreateOrUpdateEvent;
import org.kie.kogito.persistence.mongodb.index.IndexSchemaAcceptor;
import org.kie.kogito.persistence.mongodb.index.ProcessIndexEvent;

@ApplicationScoped
public class IndexManager {
    private static final long MAX_INDEX_NUMBER = 63L;
    static final String INDEX_NAME_FIELD = "name";
    static final String DEFAULT_INDEX = "_id_";
    Map<String, EntityIndexDescriptor> indexes = new ConcurrentHashMap<String, EntityIndexDescriptor>();
    Map<String, String> collectionIndexMapping = new ConcurrentHashMap<String, String>();
    @Inject
    IndexSchemaAcceptor schemaAcceptor;
    @Inject
    Event<ProcessIndexEvent> processIndexEvent;
    @Inject
    Instance<MongoClientManager> mongoClientManager;
    @ConfigProperty(name="kogito.apps.persistence.indexing", defaultValue="true")
    Boolean indexEnabled;

    public void onSchemaRegisteredEvent(@Observes SchemaRegisteredEvent event) {
        if (this.schemaAcceptor.accept(event.getSchemaType())) {
            this.indexes.putAll(event.getSchemaDescriptor().getEntityIndexDescriptors());
            if (this.indexEnabled.booleanValue()) {
                this.updateIndexes(event.getSchemaDescriptor().getEntityIndexDescriptors().values());
            }
            event.getSchemaDescriptor().getProcessDescriptor().ifPresent(processDescriptor -> this.processIndexEvent.fire((Object)new ProcessIndexEvent((ProcessDescriptor)processDescriptor)));
        }
    }

    public void onIndexCreateOrUpdateEvent(@Observes IndexCreateOrUpdateEvent event) {
        if (!this.indexEnabled.booleanValue()) {
            return;
        }
        String indexType = this.collectionIndexMapping.put(event.getCollection(), event.getIndex());
        if (!event.getIndex().equals(indexType)) {
            MongoCollection<Document> collection = this.getCollection(event.getCollection());
            EntityIndexDescriptor index = this.indexes.get(event.getIndex());
            this.updateCollection(collection, index);
        }
    }

    void updateIndexes(Collection<EntityIndexDescriptor> entityIndexDescriptorList) {
        entityIndexDescriptorList.forEach(entityIndexDescriptor -> this.getCollectionsWithIndex(entityIndexDescriptor.getName()).forEach(col -> this.updateCollection(this.getCollection((String)col), (EntityIndexDescriptor)entityIndexDescriptor)));
    }

    void updateCollection(MongoCollection<Document> collection, EntityIndexDescriptor index) {
        if (index == null) {
            return;
        }
        List<IndexModel> parsedIndexes = this.createIndexForEntity("", index);
        Map indexNameMap = parsedIndexes.stream().collect(Collectors.toMap(ind -> ind.getOptions().getName(), Function.identity()));
        List<String> indexesExists = StreamSupport.stream(collection.listIndexes().spliterator(), false).map(document -> document.getString((Object)INDEX_NAME_FIELD)).filter(name -> !DEFAULT_INDEX.equals(name)).collect(Collectors.toList());
        indexesExists.forEach(ind -> {
            if (!indexNameMap.containsKey(ind)) {
                collection.dropIndex(ind);
            }
        });
        if (63L < (long)indexNameMap.size()) {
            throw new SchemaRegistrationException("A single MongoDB collection can have no more than 64 indexes");
        }
        List indexesToAdd = indexNameMap.entrySet().stream().filter(entry -> !indexesExists.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        if (!indexesToAdd.isEmpty()) {
            collection.createIndexes(indexesToAdd);
        }
    }

    List<IndexModel> createIndexForEntity(String parentField, EntityIndexDescriptor entityIndexDescriptor) {
        String pkg = entityIndexDescriptor.getName().substring(0, entityIndexDescriptor.getName().lastIndexOf(".") + 1);
        String prefixUUID = UUID.nameUUIDFromBytes(parentField.getBytes()).toString() + ".";
        List indexesToCreate = entityIndexDescriptor.getIndexDescriptors().parallelStream().flatMap(indexDescriptor -> this.createIndex((IndexDescriptor)indexDescriptor, parentField, prefixUUID).stream()).collect(Collectors.toList());
        List subIndexesToCreate = entityIndexDescriptor.getAttributeDescriptors().parallelStream().filter(attributeDescriptor -> !attributeDescriptor.isPrimitiveType()).flatMap(attributeDescriptor -> {
            String fieldName;
            String string = fieldName = parentField.isEmpty() ? attributeDescriptor.getName() : parentField + "." + attributeDescriptor.getName();
            if (this.indexes.containsKey(attributeDescriptor.getTypeName())) {
                return this.createIndexForEntity(fieldName, this.indexes.get(attributeDescriptor.getTypeName())).stream();
            }
            if (this.indexes.containsKey(pkg + attributeDescriptor.getTypeName())) {
                return this.createIndexForEntity(fieldName, this.indexes.get(pkg + attributeDescriptor.getTypeName())).stream();
            }
            return Stream.empty();
        }).collect(Collectors.toList());
        return Stream.concat(indexesToCreate.stream(), subIndexesToCreate.stream()).collect(Collectors.toList());
    }

    Optional<IndexModel> createIndex(IndexDescriptor indexDescriptor, String parentField, String prefixUUID) {
        String indexName = prefixUUID + indexDescriptor.getName();
        List fieldNames = indexDescriptor.getIndexAttributes().stream().map(attributeName -> parentField.isEmpty() ? attributeName : parentField + "." + attributeName).collect(Collectors.toList());
        if (!fieldNames.isEmpty()) {
            return Optional.of(new IndexModel(Indexes.ascending(fieldNames), new IndexOptions().name(indexName).sparse(true)));
        }
        return Optional.empty();
    }

    List<String> getCollectionsWithIndex(String index) {
        return ((ArrayListMultimap)Multimaps.invertFrom((Multimap)Multimaps.forMap(this.collectionIndexMapping), (Multimap)ArrayListMultimap.create())).get((Object)index);
    }

    MongoCollection<Document> getCollection(String collection) {
        return ((MongoClientManager)this.mongoClientManager.get()).getCollection(collection);
    }

    Map<String, EntityIndexDescriptor> getIndexes() {
        return this.indexes;
    }

    Map<String, String> getCollectionIndexMapping() {
        return this.collectionIndexMapping;
    }
}

