/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.storage;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.ReplaceOptions;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.mongodb.model.MongoEntityMapper;
import org.kie.kogito.persistence.mongodb.query.MongoQuery;
import org.kie.kogito.persistence.mongodb.storage.StorageUtils;

public class MongoStorage<V, E>
implements Storage<String, V> {
    static final String OPERATION_TYPE = "operationType";
    MongoEntityMapper<V, E> mongoEntityMapper;
    MongoCollection<E> mongoCollection;
    com.mongodb.reactivestreams.client.MongoCollection<E> reactiveMongoCollection;
    String rootType;

    public MongoStorage(MongoCollection<E> mongoCollection, com.mongodb.reactivestreams.client.MongoCollection<E> reactiveMongoCollection, String rootType, MongoEntityMapper<V, E> mongoEntityMapper) {
        this.mongoCollection = mongoCollection;
        this.rootType = rootType;
        this.mongoEntityMapper = mongoEntityMapper;
        this.reactiveMongoCollection = reactiveMongoCollection;
    }

    public void addObjectCreatedListener(Consumer<V> consumer) {
        StorageUtils.watchCollection(this.reactiveMongoCollection, Filters.eq((String)OPERATION_TYPE, (Object)"insert"), (k, v) -> consumer.accept(v), this.mongoEntityMapper);
    }

    public void addObjectUpdatedListener(Consumer<V> consumer) {
        StorageUtils.watchCollection(this.reactiveMongoCollection, Filters.in((String)OPERATION_TYPE, Arrays.asList("update", "replace")), (k, v) -> consumer.accept(v), this.mongoEntityMapper);
    }

    public void addObjectRemovedListener(Consumer<String> consumer) {
        StorageUtils.watchCollection(this.reactiveMongoCollection, Filters.eq((String)OPERATION_TYPE, (Object)"delete"), (k, v) -> consumer.accept((String)k), this.mongoEntityMapper);
    }

    public Query<V> query() {
        return new MongoQuery<V, E>(this.mongoCollection, this.mongoEntityMapper);
    }

    public boolean containsKey(String o) {
        return this.mongoCollection.find((Bson)new Document("_id", (Object)o)).iterator().hasNext();
    }

    public Set<Map.Entry<String, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public V get(String o) {
        return Optional.ofNullable(this.mongoCollection.find((Bson)new Document("_id", (Object)o)).first()).map(e -> this.mongoEntityMapper.mapToModel(e)).orElse(null);
    }

    public V put(String s, V v) {
        V oldValue = this.get(s);
        Optional.ofNullable(oldValue).ifPresentOrElse(o -> Optional.ofNullable(v).map(n -> this.mongoEntityMapper.mapToEntity(s, n)).ifPresent(e -> this.mongoCollection.replaceOne((Bson)new Document("_id", (Object)s), e, new ReplaceOptions().upsert(true))), () -> Optional.ofNullable(v).map(n -> this.mongoEntityMapper.mapToEntity(s, n)).ifPresent(e -> this.mongoCollection.insertOne(e)));
        return (V)(Objects.nonNull(v) ? oldValue : null);
    }

    public void clear() {
        this.mongoCollection.deleteMany((Bson)new Document());
    }

    public String getRootType() {
        return this.rootType;
    }

    public V remove(String o) {
        V oldValue = this.get(o);
        Optional.ofNullable(oldValue).ifPresent(i -> this.mongoCollection.deleteOne((Bson)new Document("_id", (Object)o)));
        return oldValue;
    }
}

