/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.mongodb.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.bson.Document;
import org.bson.json.JsonWriterSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelUtils.class);
    public static final String ID = "id";
    public static final String MONGO_ID = "_id";
    public static final String ATTRIBUTE_DELIMITER = ".";
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private static final JsonWriterSettings jsonWriterSettings = JsonWriterSettings.builder().int64Converter((value, writer) -> writer.writeNumber(value.toString())).build();

    private ModelUtils() {
    }

    public static ZonedDateTime instantToZonedDateTime(Long milli) {
        return Optional.ofNullable(milli).map(time -> Instant.ofEpochMilli(time).atZone(ZoneOffset.UTC)).orElse(null);
    }

    public static Long zonedDateTimeToInstant(ZonedDateTime time) {
        return Optional.ofNullable(time).map(t -> t.toInstant().toEpochMilli()).orElse(null);
    }

    public static <T extends JsonNode> T documentToJsonNode(Document document, Class<T> type) {
        return (T)((JsonNode)Optional.ofNullable(document).map(doc -> {
            try {
                return (JsonNode)MAPPER.readValue(doc.toJson(jsonWriterSettings), type);
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Error trying to parse Process Variables", (Throwable)ex);
                return null;
            }
        }).orElse(null));
    }

    public static Document jsonNodeToDocument(JsonNode jsonNode) {
        return Optional.ofNullable(jsonNode).map(json -> Document.parse((String)json.toString())).orElse(null);
    }

    public static <T> T documentToObject(Document document, Class<T> type, UnaryOperator<String> converter) {
        ObjectNode node = ModelUtils.documentToJsonNode(document, ObjectNode.class);
        return Optional.ofNullable(node).map(n -> ModelUtils.convertAttributes(node, Optional.empty(), converter)).map(n -> MAPPER.convertValue(n, type)).orElse(null);
    }

    static ObjectNode convertAttributes(ObjectNode node, Optional<String> parentName, UnaryOperator<String> converter) {
        ObjectNode objectNode = MAPPER.createObjectNode();
        Iterator iterator = node.fields();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = parentName.map(p -> p + ATTRIBUTE_DELIMITER + (String)entry.getKey()).orElse((String)entry.getKey());
            String name = (String)converter.apply(key);
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isObject()) {
                ObjectNode childNode = ModelUtils.convertAttributes((ObjectNode)value, Optional.of(key), converter);
                objectNode.set(name, (JsonNode)childNode);
                continue;
            }
            if (value.isArray()) {
                ArrayNode childArray = MAPPER.createArrayNode();
                for (JsonNode childNode : value) {
                    if (childNode.isObject()) {
                        childArray.add((JsonNode)ModelUtils.convertAttributes((ObjectNode)childNode, Optional.of(key), converter));
                        continue;
                    }
                    childArray.add(childNode);
                }
                objectNode.set(name, (JsonNode)childArray);
                continue;
            }
            objectNode.set(name, value);
        }
        return objectNode;
    }
}

