/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.oracle.model;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.vladmihalcea.hibernate.type.json.JsonBlobType;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDef;
import org.kie.kogito.persistence.oracle.model.CacheId;

@Entity
@IdClass(value=CacheId.class)
@Table(name="kogito_data_cache", uniqueConstraints={@UniqueConstraint(columnNames={"name", "key"})}, indexes={@Index(columnList="name,key", unique=true)})
@TypeDef(name="jsonb", typeClass=JsonBlobType.class)
public class CacheEntity {
    @Id
    @Column(nullable=false)
    private String name;
    @Id
    @Column(nullable=false)
    private String key;
    @Type(type="jsonb")
    @Column(name="json_value")
    private ObjectNode value;

    public CacheEntity() {
    }

    public CacheEntity(String name, String key) {
        this.name = name;
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ObjectNode getValue() {
        return this.value;
    }

    public void setValue(ObjectNode value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CacheEntity)) {
            return false;
        }
        CacheEntity that = (CacheEntity)o;
        return this.getName().equals(that.getName()) && this.getKey().equals(that.getKey());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getKey());
    }

    public String toString() {
        return "CacheEntity{name='" + this.name + "', key='" + this.key + "', value=" + this.value + "}";
    }
}

