/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.oracle;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.properties.IfBuildProperty;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.persistence.oracle.OracleStorage;
import org.kie.kogito.persistence.oracle.model.CacheEntityRepository;

@ApplicationScoped
@IfBuildProperty(name="kogito.persistence.type", stringValue="oracle")
public class OracleStorageService
implements StorageService {
    @Inject
    CacheEntityRepository repository;
    @Inject
    ObjectMapper mapper;

    public Storage<String, String> getCache(String name) {
        return new OracleStorage<String>(name, this.repository, this.mapper, String.class);
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type) {
        return new OracleStorage<T>(name, this.repository, this.mapper, type);
    }

    public <T> Storage<String, T> getCache(String name, Class<T> type, String rootType) {
        return new OracleStorage<T>(name, this.repository, this.mapper, type, rootType);
    }
}

