/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.oracle;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.mutiny.Multi;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.query.Query;
import org.kie.kogito.persistence.oracle.OracleQuery;
import org.kie.kogito.persistence.oracle.model.CacheEntity;
import org.kie.kogito.persistence.oracle.model.CacheEntityRepository;
import org.kie.kogito.persistence.oracle.model.CacheId;

public class OracleStorage<V>
implements Storage<String, V> {
    private static final String LISTENER_NOT_AVAILABLE_IN_ORACLE_SQL = "Listener not available in Oracle";
    private CacheEntityRepository repository;
    private String cacheName;
    private Class<V> type;
    private ObjectMapper mapper;
    private String rootType;

    public OracleStorage(String cacheName, CacheEntityRepository repository, ObjectMapper mapper, Class<V> type) {
        this(cacheName, repository, mapper, type, type.getCanonicalName());
    }

    public OracleStorage(String cacheName, CacheEntityRepository repository, ObjectMapper mapper, Class<V> type, String rootType) {
        this.repository = repository;
        this.cacheName = cacheName;
        this.type = type;
        this.mapper = mapper;
        this.rootType = rootType;
    }

    public Multi<V> objectCreatedListener() {
        throw new UnsupportedOperationException(LISTENER_NOT_AVAILABLE_IN_ORACLE_SQL);
    }

    public Multi<V> objectUpdatedListener() {
        throw new UnsupportedOperationException(LISTENER_NOT_AVAILABLE_IN_ORACLE_SQL);
    }

    public Multi<String> objectRemovedListener() {
        throw new UnsupportedOperationException(LISTENER_NOT_AVAILABLE_IN_ORACLE_SQL);
    }

    public Query<V> query() {
        return new OracleQuery<V>(this.cacheName, this.repository, this.mapper, this.type);
    }

    public V get(String key) {
        return this.repository.findByIdOptional(new CacheId(this.cacheName, key)).map(this.mapper()).orElse(null);
    }

    protected Function<CacheEntity, V> mapper() {
        return entity -> {
            try {
                if (String.class.equals(this.type)) {
                    return this.mapper.treeToValue((TreeNode)entity.getValue().get("value"), this.type);
                }
                return this.mapper.treeToValue((TreeNode)entity.getValue(), this.type);
            }
            catch (JsonProcessingException ex) {
                throw new RuntimeException(String.format("Failed to convert JSON into type %s", this.rootType), ex);
            }
        };
    }

    public V put(String key, V value) {
        ObjectNode json;
        if (String.class.equals(this.type)) {
            json = this.mapper.createObjectNode();
            json.put("value", (String)value);
        } else {
            json = (ObjectNode)this.mapper.valueToTree(value);
        }
        CacheId cacheId = new CacheId(this.cacheName, key);
        Optional byId = this.repository.findByIdOptional(cacheId);
        CacheEntity entity = byId.isPresent() ? (CacheEntity)byId.get() : new CacheEntity(this.cacheName, key);
        entity.setValue(json);
        this.repository.persist(entity);
        return value;
    }

    public V remove(String key) {
        V value = this.get(key);
        if (value != null) {
            this.repository.deleteById(new CacheId(this.cacheName, key));
        }
        return value;
    }

    public boolean containsKey(String key) {
        return this.repository.count("name = ?1 and key = ?2", new Object[]{this.cacheName, key}) == 1L;
    }

    public Map<String, V> entries() {
        return this.repository.stream("name", new Object[]{this.cacheName}).collect(Collectors.toMap(CacheEntity::getKey, this.mapper()));
    }

    public void clear() {
        this.repository.delete("name", new Object[]{this.cacheName});
    }

    public String getRootType() {
        return this.rootType;
    }
}

