/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.oracle.hibernate;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.usertype.UserType;

public class JsonBinaryType
implements UserType {
    private ObjectMapper mapper = new ObjectMapper();

    public int[] sqlTypes() {
        return new int[]{2000};
    }

    public Class returnedClass() {
        return JsonNode.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return Objects.equals(x, y);
    }

    public int hashCode(Object x) throws HibernateException {
        return Objects.hashCode(x);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        String json = rs.getString(names[0]);
        if (json == null) {
            return null;
        }
        try {
            return this.mapper.readTree(json.getBytes("UTF-8"));
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to convert String to Invoice: " + ex.getMessage(), ex);
        }
    }

    public void nullSafeSet(PreparedStatement ps, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            ps.setNull(index, 1111);
            return;
        }
        if (value instanceof ObjectNode) {
            try {
                ps.setObject(index, (Object)value.toString(), -16);
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format("Failed to convert JSON to String: %s", ex.getMessage()), ex);
            }
        } else {
            throw new RuntimeException(String.format("Cannot convert type %s as JSON String", value.getClass().getCanonicalName()));
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        if (value instanceof JsonNode) {
            return ((JsonNode)value).deepCopy();
        }
        throw new RuntimeException(String.format("Cannot deep copy type %s", value.getClass().getCanonicalName()));
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return this.deepCopy(value).toString();
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        try {
            return this.mapper.readTree(cached.toString());
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(String.format("Failed to convert String to JSON: %s", ex.getMessage()), ex);
        }
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }
}

