/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.kie.kogito.persistence.api.proto.AttributeDescriptor;
import org.kie.kogito.persistence.api.proto.DomainDescriptor;

public class TestUtils {
    static final String PROCESS_ID = "travels";
    static final String PROCESS_TYPE = "org.acme.travels.travels.Travels";
    static final DomainDescriptor DOMAIN_DESCRIPTOR = new DomainDescriptor();
    static final List<DomainDescriptor> ADDITIONAL_DESCRIPTORS;

    static FileDescriptor getTestFileDescriptor() {
        String content = TestUtils.getTestFileContent();
        SerializationContextImpl ctx = new SerializationContextImpl(Configuration.builder().build());
        ctx.registerProtoFiles(FileDescriptorSource.fromString((String)"domainModel", (String)content));
        return (FileDescriptor)ctx.getFileDescriptors().get("domainModel");
    }

    static String getTestFileContent() {
        return TestUtils.getTestFileContent("test.proto");
    }

    static String getTestFileInvalidContent() {
        return TestUtils.getTestFileContent("test_invalid.proto");
    }

    static String getTestFileContent(String protofile) {
        try {
            Path path = Paths.get(Thread.currentThread().getContextClassLoader().getResource(protofile).toURI());
            return new String(Files.readAllBytes(path));
        }
        catch (IOException | URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        DOMAIN_DESCRIPTOR.setTypeName(PROCESS_TYPE);
        DOMAIN_DESCRIPTOR.setAttributes(List.of(new AttributeDescriptor("flight", "org.acme.travels.travels.Flight"), new AttributeDescriptor("hotel", "org.acme.travels.travels.Hotel"), new AttributeDescriptor("id", "java.lang.String"), new AttributeDescriptor("metadata", "java.lang.String")));
        DomainDescriptor address = new DomainDescriptor();
        address.setTypeName("org.acme.travels.travels.Address");
        address.setAttributes(List.of(new AttributeDescriptor("city", "java.lang.String"), new AttributeDescriptor("country", "java.lang.String"), new AttributeDescriptor("street", "java.lang.String"), new AttributeDescriptor("zipCode", "java.lang.String")));
        DomainDescriptor flight = new DomainDescriptor();
        flight.setTypeName("org.acme.travels.travels.Flight");
        flight.setAttributes(List.of(new AttributeDescriptor("arrival", "java.lang.String"), new AttributeDescriptor("departure", "java.lang.String"), new AttributeDescriptor("flightNumber", "java.lang.String"), new AttributeDescriptor("gate", "java.lang.String"), new AttributeDescriptor("seat", "java.lang.String")));
        DomainDescriptor hotel = new DomainDescriptor();
        hotel.setTypeName("org.acme.travels.travels.Hotel");
        hotel.setAttributes(List.of(new AttributeDescriptor("address", "org.acme.travels.travels.Address"), new AttributeDescriptor("bookingNumber", "java.lang.String"), new AttributeDescriptor("name", "java.lang.String"), new AttributeDescriptor("phone", "java.lang.String"), new AttributeDescriptor("room", "java.lang.String")));
        ADDITIONAL_DESCRIPTORS = List.of(address, flight, hotel);
    }
}

