/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import io.quarkus.runtime.StartupEvent;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.kie.kogito.persistence.api.Storage;
import org.kie.kogito.persistence.api.StorageService;
import org.kie.kogito.persistence.api.schema.ProcessDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaRegisteredEvent;
import org.kie.kogito.persistence.api.schema.SchemaType;
import org.kie.kogito.persistence.protobuf.FileDescriptorRegisteredEvent;
import org.kie.kogito.persistence.protobuf.ProtobufValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProtobufService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufService.class);
    static final SchemaType SCHEMA_TYPE = new SchemaType("proto");
    public static final String DOMAIN_MODEL_PROTO_NAME = "domainModel";
    @Inject
    FileDescriptorSource kogitoDescriptors;
    @Inject
    Event<FileDescriptorRegisteredEvent> domainModelEvent;
    @Inject
    Event<SchemaRegisteredEvent> schemaEvent;
    @Inject
    StorageService storageService;

    void onStart(@Observes StartupEvent ev) {
        this.kogitoDescriptors.getFileDescriptors().forEach((name, bytes) -> {
            LOGGER.info("Registering Kogito ProtoBuffer file: {}", name);
            this.schemaEvent.fire((Object)new SchemaRegisteredEvent(new SchemaDescriptor(name, new String((char[])bytes), null), SCHEMA_TYPE));
        });
    }

    public Storage<String, String> getProtobufCache() {
        return this.storageService.getCache("___protobuf_metadata", String.class);
    }

    public void registerProtoBufferType(String content) throws ProtobufValidationException {
        Descriptor descriptor;
        LOGGER.debug("Registering new ProtoBuffer file with content: \n{}", (Object)content);
        content = content.replaceAll("kogito.Date", "string");
        SerializationContextImpl ctx = new SerializationContextImpl(Configuration.builder().build());
        try {
            ctx.registerProtoFiles(this.kogitoDescriptors);
            ctx.registerProtoFiles(FileDescriptorSource.fromString((String)DOMAIN_MODEL_PROTO_NAME, (String)content));
        }
        catch (Exception ex) {
            LOGGER.warn("Error trying to parse proto buffer file: {}", (Object)ex.getMessage(), (Object)ex);
            throw new ProtobufValidationException(ex.getMessage());
        }
        FileDescriptor desc = (FileDescriptor)ctx.getFileDescriptors().get(DOMAIN_MODEL_PROTO_NAME);
        Option processIdOption = desc.getOption("kogito_id");
        if (processIdOption == null || processIdOption.getValue() == null) {
            throw new ProtobufValidationException("Missing marker for process id in proto file, please add option kogito_id=\"processid\"");
        }
        String processId = (String)processIdOption.getValue();
        Option model = desc.getOption("kogito_model");
        if (model == null || model.getValue() == null) {
            throw new ProtobufValidationException("Missing marker for main message type in proto file, please add option kogito_model=\"messagename\"");
        }
        String messageName = (String)model.getValue();
        String fullTypeName = desc.getPackage() == null ? messageName : desc.getPackage() + "." + messageName;
        try {
            descriptor = ctx.getMessageDescriptor(fullTypeName);
        }
        catch (IllegalArgumentException ex) {
            throw new ProtobufValidationException(String.format("Could not find message with name: %s in proto file, e, please review option kogito_model", fullTypeName));
        }
        this.validateDescriptorField(messageName, descriptor, "metadata");
        try {
            this.schemaEvent.fire((Object)new SchemaRegisteredEvent(new SchemaDescriptor(processId + ".proto", content, new ProcessDescriptor(processId, fullTypeName)), SCHEMA_TYPE));
        }
        catch (RuntimeException ex) {
            throw new ProtobufValidationException(ex.getMessage());
        }
        this.domainModelEvent.fire((Object)new FileDescriptorRegisteredEvent(desc));
    }

    private void validateDescriptorField(String messageName, Descriptor descriptor, String processInstancesDomainAttribute) throws ProtobufValidationException {
        FieldDescriptor processInstances = descriptor.findFieldByName(processInstancesDomainAttribute);
        if (processInstances == null) {
            throw new ProtobufValidationException(String.format("Could not find %s attribute in proto message: %s", processInstancesDomainAttribute, messageName));
        }
    }
}

