/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.api.schema.AttributeDescriptor;
import org.kie.kogito.persistence.api.schema.EntityIndexDescriptor;
import org.kie.kogito.persistence.protobuf.ProtoIndexParser;
import org.kie.kogito.persistence.protobuf.TestUtils;

class ProtoIndexParserTest {
    ProtoIndexParserTest() {
    }

    @Test
    void testConfigureBuilder() {
        Map entityIndexes = this.createFileDescriptor().getMessageTypes().stream().map(t -> (EntityIndexDescriptor)t.getProcessedAnnotation("Indexed")).filter(Objects::nonNull).collect(Collectors.toMap(EntityIndexDescriptor::getName, Function.identity()));
        Assertions.assertEquals(TestUtils.getValidEntityIndexDescriptors(false), entityIndexes);
    }

    @Test
    void testConfigureBuilderWithInvalidFile() {
        SerializationContextImpl ctx = new SerializationContextImpl(ProtoIndexParser.configureBuilder().build());
        FileDescriptorSource invalidFileDescriptorSource = FileDescriptorSource.fromString((String)"invalid", (String)"invalid");
        try {
            ctx.registerProtoFiles(invalidFileDescriptorSource);
            Assertions.fail((String)"Failed to process invalid proto file");
        }
        catch (DescriptorParserException descriptorParserException) {
            // empty catch block
        }
    }

    @Test
    void testCreateEntityIndexeDescriptors() {
        FileDescriptor fileDescriptor = this.createFileDescriptor();
        Map entityIndexes = this.createFileDescriptor().getMessageTypes().stream().map(t -> (EntityIndexDescriptor)t.getProcessedAnnotation("Indexed")).filter(Objects::nonNull).collect(Collectors.toMap(EntityIndexDescriptor::getName, Function.identity()));
        Map indexDescriptor = ProtoIndexParser.createEntityIndexeDescriptors((FileDescriptor)fileDescriptor, entityIndexes);
        Assertions.assertEquals(TestUtils.getValidEntityIndexDescriptors(true), (Object)indexDescriptor);
    }

    @Test
    void testCreateAttributeDescriptor() {
        FieldDescriptor roomField = this.createFileDescriptor().getMessageTypes().stream().filter(descriptor -> "org.acme.travels.travels.Hotel".equals(descriptor.getFullName())).findAny().get().findFieldByName("room");
        AttributeDescriptor attributeDescriptor = ProtoIndexParser.createAttributeDescriptor((FieldDescriptor)roomField, null);
        Assertions.assertEquals((Object)new AttributeDescriptor("room", "string", true), (Object)attributeDescriptor);
    }

    private FileDescriptor createFileDescriptor() {
        SerializationContextImpl ctx = new SerializationContextImpl(ProtoIndexParser.configureBuilder().build());
        String content = TestUtils.getTestFileContent();
        FileDescriptorSource fileDescriptorSource = FileDescriptorSource.fromString((String)"test", (String)content);
        ctx.registerProtoFiles(fileDescriptorSource);
        return (FileDescriptor)ctx.getFileDescriptors().get("test");
    }
}

