/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.kie.kogito.persistence.api.schema.AttributeDescriptor;
import org.kie.kogito.persistence.api.schema.EntityIndexDescriptor;
import org.kie.kogito.persistence.api.schema.IndexDescriptor;

class ProtoIndexParser
implements AnnotationMetadataCreator<EntityIndexDescriptor, Descriptor> {
    static final String INDEXED_ANNOTATION = "Indexed";
    static final String INDEXED_INDEX_ATTRIBUTE = "index";
    static final String FIELDS_ANNOTATION = "Fields";
    static final String FIELD_ANNOTATION = "Field";
    static final String FIELD_NAME_ATTRIBUTE = "name";
    static final String FIELD_INDEX_ATTRIBUTE = "index";
    static final String FIELD_STORE_ATTRIBUTE = "store";
    static final String FIELD_INDEX_NULL_AS_ATTRIBUTE = "indexNullAs";
    static final String SORTABLE_ANNOTATION = "SortableField";
    static final String INDEX_YES = "Index.YES";
    static final String INDEX_NO = "Index.NO";
    static final String STORE_YES = "Store.YES";
    static final String STORE_NO = "Store.NO";
    static final String DO_NOT_INDEX_NULL = "__DO_NOT_INDEX_NULL__";
    static final String DEFAULT_NULL_TOKEN = "__DEFAULT_NULL_TOKEN__";

    ProtoIndexParser() {
    }

    static Configuration.Builder configureBuilder() {
        Configuration.Builder builder = Configuration.builder();
        builder.annotationsConfig().annotation(INDEXED_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.MESSAGE}).attribute("index").type(AnnotationElement.AttributeType.STRING).defaultValue((Object)"").metadataCreator((AnnotationMetadataCreator)new ProtoIndexParser()).annotation(FIELD_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.FIELD}).repeatable(FIELDS_ANNOTATION).attribute(FIELD_NAME_ATTRIBUTE).type(AnnotationElement.AttributeType.STRING).defaultValue((Object)"").attribute("index").type(AnnotationElement.AttributeType.IDENTIFIER).allowedValues(new String[]{INDEX_YES, INDEX_NO}).defaultValue((Object)INDEX_YES).attribute(FIELD_STORE_ATTRIBUTE).type(AnnotationElement.AttributeType.IDENTIFIER).allowedValues(new String[]{STORE_YES, STORE_NO}).defaultValue((Object)STORE_NO).attribute(FIELD_INDEX_NULL_AS_ATTRIBUTE).type(AnnotationElement.AttributeType.STRING).allowedValues(new String[]{DO_NOT_INDEX_NULL, DEFAULT_NULL_TOKEN}).defaultValue((Object)DO_NOT_INDEX_NULL).annotation(SORTABLE_ANNOTATION, new AnnotationElement.AnnotationTarget[]{AnnotationElement.AnnotationTarget.FIELD});
        return builder;
    }

    public EntityIndexDescriptor create(Descriptor annotatedDescriptor, AnnotationElement.Annotation annotation) {
        String name = annotatedDescriptor.getFullName();
        ArrayList<IndexDescriptor> indexes = new ArrayList<IndexDescriptor>(annotatedDescriptor.getFields().size());
        ArrayList<AttributeDescriptor> fields = new ArrayList<AttributeDescriptor>(annotatedDescriptor.getFields().size());
        for (FieldDescriptor fd : annotatedDescriptor.getFields()) {
            AnnotationElement.Annotation fieldAnnotation = (AnnotationElement.Annotation)fd.getAnnotations().get(FIELD_ANNOTATION);
            if (fieldAnnotation == null) continue;
            String fieldName = Optional.ofNullable((String)fieldAnnotation.getAttributeValue(FIELD_NAME_ATTRIBUTE).getValue()).filter(a -> !a.isEmpty()).orElseGet(() -> ((FieldDescriptor)fd).getName());
            boolean isIndexed = INDEX_YES.equals(fieldAnnotation.getAttributeValue("index").getValue());
            fields.add(ProtoIndexParser.createAttributeDescriptor(fd, fieldName));
            if (!isIndexed) continue;
            indexes.add(new IndexDescriptor(fieldName, List.of(fieldName)));
        }
        return new EntityIndexDescriptor(name, indexes, fields);
    }

    static Map<String, EntityIndexDescriptor> createEntityIndexDescriptors(FileDescriptor desc, Map<String, EntityIndexDescriptor> entityIndexes) {
        desc.getMessageTypes().forEach(mDesc -> {
            String typeName = mDesc.getFullName();
            EntityIndexDescriptor entityIndex = (EntityIndexDescriptor)entityIndexes.get(typeName);
            if (entityIndex != null) {
                Set fieldNames = entityIndex.getAttributeDescriptors().stream().map(AttributeDescriptor::getName).collect(Collectors.toSet());
                mDesc.getFields().stream().filter(fDesc -> !fieldNames.contains(fDesc.getName())).forEach(fDesc -> entityIndex.getAttributeDescriptors().add(ProtoIndexParser.createAttributeDescriptor(fDesc, null)));
            }
        });
        return entityIndexes;
    }

    static AttributeDescriptor createAttributeDescriptor(FieldDescriptor fDesc, String name) {
        String fieldName = Objects.isNull(name) || name.isEmpty() ? fDesc.getName() : name;
        boolean isPrimitiveType = !Objects.isNull(fDesc.getType()) && !Objects.isNull(fDesc.getJavaType());
        String typeName = fDesc.getTypeName();
        return new AttributeDescriptor(fieldName, typeName, isPrimitiveType);
    }
}

