/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.event.Event;
import org.infinispan.protostream.FileDescriptorSource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.persistence.api.schema.ProcessDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaRegisteredEvent;
import org.kie.kogito.persistence.protobuf.FileDescriptorRegisteredEvent;
import org.kie.kogito.persistence.protobuf.ProtobufMonitorService;
import org.kie.kogito.persistence.protobuf.ProtobufService;
import org.kie.kogito.persistence.protobuf.ProtobufValidationException;
import org.kie.kogito.persistence.protobuf.TestUtils;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class ProtobufServiceTest {
    FileDescriptorSource kogitoDescriptors;
    @Mock
    ProtobufMonitorService protobufMonitorService;
    @Mock
    Event<FileDescriptorRegisteredEvent> domainModelEvent;
    @Mock
    Event<SchemaRegisteredEvent> schemaEvent;
    @InjectMocks
    ProtobufService protobufService;

    ProtobufServiceTest() {
    }

    @BeforeEach
    void prepare() {
        this.protobufService.kogitoDescriptors = this.kogitoDescriptors = new FileDescriptorSource();
    }

    @Test
    void onStart() {
        String content = TestUtils.getTestFileContent();
        this.kogitoDescriptors.addProtoFile("test", content);
        StartupEvent event = (StartupEvent)Mockito.mock(StartupEvent.class);
        this.protobufService.onStart(event);
        ((Event)Mockito.verify(this.schemaEvent)).fire((Object)((SchemaRegisteredEvent)ArgumentMatchers.eq((Object)new SchemaRegisteredEvent(new SchemaDescriptor("test", content, TestUtils.getValidEntityIndexDescriptors(true), null), ProtobufService.SCHEMA_TYPE))));
        ((ProtobufMonitorService)Mockito.verify((Object)this.protobufMonitorService)).startMonitoring();
    }

    @Test
    void registerProtoBufferTypeWithInvalidKogitoDescriptors() {
        this.kogitoDescriptors.addProtoFile("test", "test");
        String content = TestUtils.getTestFileContent();
        String exceptionMessage = "";
        try {
            this.protobufService.registerProtoBufferType(content);
        }
        catch (ProtobufValidationException e) {
            exceptionMessage = e.getMessage();
        }
        Assertions.assertTrue((boolean)exceptionMessage.contains("java.lang.IllegalStateException"));
        ((Event)Mockito.verify(this.schemaEvent, (VerificationMode)Mockito.never())).fire((Object)((SchemaRegisteredEvent)ArgumentMatchers.any(SchemaRegisteredEvent.class)));
        ((Event)Mockito.verify(this.domainModelEvent, (VerificationMode)Mockito.never())).fire((Object)((FileDescriptorRegisteredEvent)ArgumentMatchers.any(FileDescriptorRegisteredEvent.class)));
    }

    @Test
    void registerProtoBufferTypeWithInvalidProtoFile() {
        String content = TestUtils.getTestFileInvalidContent();
        String exceptionMessage = "";
        try {
            this.protobufService.registerProtoBufferType(content);
        }
        catch (ProtobufValidationException e) {
            exceptionMessage = e.getMessage();
        }
        Assertions.assertTrue((boolean)exceptionMessage.contains("Could not find metadata attribute in proto message"));
        ((Event)Mockito.verify(this.schemaEvent, (VerificationMode)Mockito.never())).fire((Object)((SchemaRegisteredEvent)ArgumentMatchers.any(SchemaRegisteredEvent.class)));
        ((Event)Mockito.verify(this.domainModelEvent, (VerificationMode)Mockito.never())).fire((Object)((FileDescriptorRegisteredEvent)ArgumentMatchers.any(FileDescriptorRegisteredEvent.class)));
    }

    @Test
    void registerProtoBufferTypeSchemaRegistrationFailed() {
        String testExceptionMessage = "test schema registration fail";
        ((Event)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(testExceptionMessage)}).when(this.schemaEvent)).fire((Object)((SchemaRegisteredEvent)ArgumentMatchers.any(SchemaRegisteredEvent.class)));
        String content = TestUtils.getTestFileContent();
        String exceptionMessage = "";
        try {
            this.protobufService.registerProtoBufferType(content);
        }
        catch (ProtobufValidationException e) {
            exceptionMessage = e.getMessage();
        }
        Assertions.assertEquals((Object)testExceptionMessage, (Object)exceptionMessage);
        ((Event)Mockito.verify(this.schemaEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new SchemaRegisteredEvent(new SchemaDescriptor("travels.proto", content, TestUtils.getValidEntityIndexDescriptors(true), new ProcessDescriptor("travels", "org.acme.travels.travels.Travels")), ProtobufService.SCHEMA_TYPE));
        ((Event)Mockito.verify(this.domainModelEvent, (VerificationMode)Mockito.never())).fire((Object)((FileDescriptorRegisteredEvent)ArgumentMatchers.any(FileDescriptorRegisteredEvent.class)));
    }

    @Test
    void registerProtoBufferType() {
        String content = TestUtils.getTestFileContent();
        try {
            this.protobufService.registerProtoBufferType(content);
        }
        catch (ProtobufValidationException e) {
            Assertions.fail((String)"RegisterProtoBufferType failed", (Throwable)e);
        }
        ((Event)Mockito.verify(this.schemaEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)new SchemaRegisteredEvent(new SchemaDescriptor("travels.proto", content, TestUtils.getValidEntityIndexDescriptors(true), new ProcessDescriptor("travels", "org.acme.travels.travels.Travels")), ProtobufService.SCHEMA_TYPE));
        ((Event)Mockito.verify(this.domainModelEvent, (VerificationMode)Mockito.times((int)1))).fire((Object)((FileDescriptorRegisteredEvent)ArgumentMatchers.any(FileDescriptorRegisteredEvent.class)));
    }
}

