/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.protobuf;

import io.quarkus.runtime.StartupEvent;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Event;
import jakarta.enterprise.event.Observes;
import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.infinispan.protostream.descriptors.Option;
import org.infinispan.protostream.impl.SerializationContextImpl;
import org.kie.kogito.persistence.api.schema.EntityIndexDescriptor;
import org.kie.kogito.persistence.api.schema.ProcessDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaDescriptor;
import org.kie.kogito.persistence.api.schema.SchemaRegisteredEvent;
import org.kie.kogito.persistence.api.schema.SchemaType;
import org.kie.kogito.persistence.protobuf.FileDescriptorRegisteredEvent;
import org.kie.kogito.persistence.protobuf.ProtoIndexParser;
import org.kie.kogito.persistence.protobuf.ProtobufFileRegistrationException;
import org.kie.kogito.persistence.protobuf.ProtobufMonitorService;
import org.kie.kogito.persistence.protobuf.ProtobufValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ProtobufService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtobufService.class);
    static final SchemaType SCHEMA_TYPE = new SchemaType("proto");
    static final String DOMAIN_MODEL_PROTO_NAME = "domainModel";
    @Inject
    FileDescriptorSource kogitoDescriptors;
    @Inject
    ProtobufMonitorService protobufMonitorService;
    @Inject
    Event<FileDescriptorRegisteredEvent> domainModelEvent;
    @Inject
    Event<SchemaRegisteredEvent> schemaEvent;

    void onStart(@Observes StartupEvent ev) {
        this.kogitoDescriptors.getFileDescriptors().forEach((name, bytes) -> {
            LOGGER.info("Registering Kogito ProtoBuffer file: {}", name);
            String content = new String((char[])bytes);
            try {
                SerializationContext ctx = this.createSerializationContext(FileDescriptorSource.fromString((String)name, (String)content));
                FileDescriptor desc = (FileDescriptor)ctx.getFileDescriptors().get(name);
                Map<String, EntityIndexDescriptor> entityIndexes = desc.getMessageTypes().stream().map(t -> (EntityIndexDescriptor)t.getProcessedAnnotation("Indexed")).filter(Objects::nonNull).collect(Collectors.toMap(EntityIndexDescriptor::getName, Function.identity()));
                Map<String, EntityIndexDescriptor> entityIndexDescriptors = ProtoIndexParser.createEntityIndexDescriptors(desc, entityIndexes);
                this.schemaEvent.fire((Object)new SchemaRegisteredEvent(new SchemaDescriptor(name, content, entityIndexDescriptors, null), SCHEMA_TYPE));
            }
            catch (ProtobufValidationException e) {
                throw new ProtobufFileRegistrationException(e);
            }
        });
        this.protobufMonitorService.startMonitoring();
    }

    public void registerProtoBufferType(String content) throws ProtobufValidationException {
        Descriptor descriptor;
        LOGGER.debug("Registering new ProtoBuffer file with content: \n{}", (Object)content);
        SerializationContext ctx = this.createSerializationContext(this.kogitoDescriptors, FileDescriptorSource.fromString((String)DOMAIN_MODEL_PROTO_NAME, (String)content));
        FileDescriptor desc = (FileDescriptor)ctx.getFileDescriptors().get(DOMAIN_MODEL_PROTO_NAME);
        Option processIdOption = desc.getOption("kogito_id");
        if (processIdOption == null || processIdOption.getValue() == null) {
            throw new ProtobufValidationException("Missing marker for process id in proto file, please add option kogito_id=\"processid\"");
        }
        String processId = (String)processIdOption.getValue();
        Option model = desc.getOption("kogito_model");
        if (model == null || model.getValue() == null) {
            throw new ProtobufValidationException("Missing marker for main message type in proto file, please add option kogito_model=\"messagename\"");
        }
        String messageName = (String)model.getValue();
        String fullTypeName = desc.getPackage() == null ? messageName : desc.getPackage() + "." + messageName;
        try {
            descriptor = ctx.getMessageDescriptor(fullTypeName);
        }
        catch (IllegalArgumentException ex) {
            throw new ProtobufValidationException(String.format("Could not find message with name: %s in proto file, e, please review option kogito_model", fullTypeName));
        }
        this.validateDescriptorField(messageName, descriptor, "metadata");
        Map<String, EntityIndexDescriptor> entityIndexes = desc.getMessageTypes().stream().map(t -> (EntityIndexDescriptor)t.getProcessedAnnotation("Indexed")).filter(Objects::nonNull).collect(Collectors.toMap(EntityIndexDescriptor::getName, Function.identity()));
        Map<String, EntityIndexDescriptor> entityIndexedDescriptors = ProtoIndexParser.createEntityIndexDescriptors(desc, entityIndexes);
        try {
            this.schemaEvent.fire((Object)new SchemaRegisteredEvent(new SchemaDescriptor(processId + ".proto", content, entityIndexedDescriptors, new ProcessDescriptor(processId, fullTypeName)), SCHEMA_TYPE));
        }
        catch (RuntimeException ex) {
            throw new ProtobufValidationException(ex.getMessage(), ex);
        }
        this.domainModelEvent.fire((Object)new FileDescriptorRegisteredEvent(desc));
    }

    private void validateDescriptorField(String messageName, Descriptor descriptor, String processInstancesDomainAttribute) throws ProtobufValidationException {
        FieldDescriptor processInstances = descriptor.findFieldByName(processInstancesDomainAttribute);
        if (processInstances == null) {
            throw new ProtobufValidationException(String.format("Could not find %s attribute in proto message: %s", processInstancesDomainAttribute, messageName));
        }
    }

    private SerializationContext createSerializationContext(FileDescriptorSource ... fileDescriptorSources) throws ProtobufValidationException {
        SerializationContextImpl ctx = new SerializationContextImpl(ProtoIndexParser.configureBuilder().build());
        try {
            Arrays.stream(fileDescriptorSources).forEach(arg_0 -> ((SerializationContext)ctx).registerProtoFiles(arg_0));
        }
        catch (Exception ex) {
            LOGGER.warn("Error trying to parse proto buffer file: {}", (Object)ex.getMessage(), (Object)ex);
            throw new ProtobufValidationException(ex.getMessage());
        }
        return ctx;
    }
}

