/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.reporting.database;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import jakarta.persistence.EntityManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.persistence.reporting.database.DatabaseManager;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.ApplyMappingSqlBuilder;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.Context;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.IndexesSqlBuilder;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.TableSqlBuilder;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.TriggerDeleteSqlBuilder;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.TriggerInsertSqlBuilder;
import org.kie.kogito.persistence.reporting.model.Field;
import org.kie.kogito.persistence.reporting.model.JsonField;
import org.kie.kogito.persistence.reporting.model.Mapping;
import org.kie.kogito.persistence.reporting.model.MappingDefinition;
import org.kie.kogito.persistence.reporting.model.PartitionField;
import org.kie.kogito.persistence.reporting.model.paths.JoinPathSegment;
import org.kie.kogito.persistence.reporting.model.paths.PathSegment;
import org.kie.kogito.persistence.reporting.model.paths.TerminalPathSegment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDatabaseManagerImpl<T, F extends Field, P extends PartitionField, J extends JsonField<T>, M extends Mapping<T, J>, D extends MappingDefinition<T, F, P, J, M>, C extends Context<T, F, P, J, M>>
implements DatabaseManager<T, F, P, J, M, D, C> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDatabaseManagerImpl.class);
    private IndexesSqlBuilder<T, F, P, J, M, C> indexesSqlBuilder;
    private TableSqlBuilder<T, F, P, J, M, C> tableSqlBuilder;
    private TriggerDeleteSqlBuilder<T, F, P, J, M, C> triggerDeleteSqlBuilder;
    private TriggerInsertSqlBuilder<T, F, P, J, M, C> triggerInsertSqlBuilder;
    private ApplyMappingSqlBuilder<T, F, P, J, M, C> applyMappingSqlBuilder;

    protected BaseDatabaseManagerImpl() {
    }

    protected BaseDatabaseManagerImpl(IndexesSqlBuilder<T, F, P, J, M, C> indexesSqlBuilder, TableSqlBuilder<T, F, P, J, M, C> tableSqlBuilder, TriggerDeleteSqlBuilder<T, F, P, J, M, C> triggerDeleteSqlBuilder, TriggerInsertSqlBuilder<T, F, P, J, M, C> triggerInsertSqlBuilder, ApplyMappingSqlBuilder<T, F, P, J, M, C> applyMappingSqlBuilder) {
        this.indexesSqlBuilder = Objects.requireNonNull(indexesSqlBuilder);
        this.tableSqlBuilder = Objects.requireNonNull(tableSqlBuilder);
        this.triggerDeleteSqlBuilder = Objects.requireNonNull(triggerDeleteSqlBuilder);
        this.triggerInsertSqlBuilder = Objects.requireNonNull(triggerInsertSqlBuilder);
        this.applyMappingSqlBuilder = Objects.requireNonNull(applyMappingSqlBuilder);
    }

    protected abstract EntityManager getEntityManager(String var1);

    protected abstract TerminalPathSegment<T, J, M> buildTerminalPathSegment(String var1, PathSegment var2, M var3);

    @Override
    public void createArtifacts(D mappingDefinition) {
        try {
            ObjectWriter objectWriter = CloudEventUtils.Mapper.mapper().writerWithDefaultPrettyPrinter();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("Creating artifacts for:%n%s", objectWriter.writeValueAsString(mappingDefinition)));
            }
            LOGGER.info("Building Context...");
            Object context = this.createContext(mappingDefinition);
            LOGGER.info("Creating TABLE...");
            String sourceTableName = mappingDefinition.getSourceTableName();
            this.getEntityManager(sourceTableName).createNativeQuery(this.tableSqlBuilder.createTableSql(context)).executeUpdate();
            LOGGER.info("Creating INDEXES...");
            this.getEntityManager(sourceTableName).createNativeQuery(this.indexesSqlBuilder.createTableIndexesSql(context)).executeUpdate();
            LOGGER.info("Creating INSERT TRIGGER FUNCTION...");
            this.getEntityManager(sourceTableName).createNativeQuery(this.triggerInsertSqlBuilder.createInsertTriggerFunctionSql(context)).executeUpdate();
            LOGGER.info("Creating INSERT TRIGGER...");
            this.getEntityManager(sourceTableName).createNativeQuery(this.triggerInsertSqlBuilder.createInsertTriggerSql(context)).executeUpdate();
            LOGGER.info("Creating DELETE TRIGGER FUNCTION...");
            this.getEntityManager(sourceTableName).createNativeQuery(this.triggerDeleteSqlBuilder.createDeleteTriggerFunctionSql(context)).executeUpdate();
            LOGGER.info("Creating DELETE TRIGGER...");
            this.getEntityManager(sourceTableName).createNativeQuery(this.triggerDeleteSqlBuilder.createDeleteTriggerSql(context)).executeUpdate();
            LOGGER.info("Applying mappings to existing data...");
            this.getEntityManager(sourceTableName).createNativeQuery(this.applyMappingSqlBuilder.apply(context)).executeUpdate();
        }
        catch (JsonProcessingException jpe) {
            LOGGER.error(jpe.getMessage());
        }
    }

    @Override
    public void destroyArtifacts(D mappingDefinition) {
        LOGGER.info("Building Context...");
        Object context = this.createContext(mappingDefinition);
        LOGGER.info("Destroying TABLE...");
        String sourceTableName = mappingDefinition.getSourceTableName();
        this.getEntityManager(sourceTableName).createNativeQuery(this.tableSqlBuilder.dropTableSql(context)).executeUpdate();
        LOGGER.info("Destroying INDEXES...");
        this.getEntityManager(sourceTableName).createNativeQuery(this.indexesSqlBuilder.dropTableIndexesSql(context)).executeUpdate();
        LOGGER.info("Destroying INSERT TRIGGER ...");
        this.getEntityManager(sourceTableName).createNativeQuery(this.triggerInsertSqlBuilder.dropInsertTriggerSql(context)).executeUpdate();
        LOGGER.info("Destroying INSERT TRIGGER FUNCTION...");
        this.getEntityManager(sourceTableName).createNativeQuery(this.triggerInsertSqlBuilder.dropInsertTriggerFunctionSql(context)).executeUpdate();
        LOGGER.info("Destroying DELETE TRIGGER ...");
        this.getEntityManager(sourceTableName).createNativeQuery(this.triggerDeleteSqlBuilder.dropDeleteTriggerSql(context)).executeUpdate();
        LOGGER.info("Destroying DELETE TRIGGER FUNCTION...");
        this.getEntityManager(sourceTableName).createNativeQuery(this.triggerDeleteSqlBuilder.dropDeleteTriggerFunctionSql(context)).executeUpdate();
    }

    protected List<PathSegment> parsePathSegments(List<M> mappings) {
        int[] groupCount = new int[]{0};
        ArrayList<PathSegment> mappingPaths = new ArrayList<PathSegment>();
        mappings.forEach(mapping -> {
            String srcPath = mapping.getSourceJsonPath();
            String[] pathParts = srcPath.split("\\.");
            List<PathSegment> paths = mappingPaths;
            PathSegment parent = null;
            for (int idx = 0; idx < pathParts.length; ++idx) {
                String pathPart = pathParts[idx];
                Optional<PathSegment> path = paths.stream().filter(p -> Objects.equals(p.getSegment(), pathPart)).findFirst();
                if (path.isEmpty()) {
                    PathSegment sibling;
                    if (idx == pathParts.length - 1) {
                        sibling = this.buildTerminalPathSegment(pathPart, parent, mapping);
                    } else if (pathPart.endsWith("[]")) {
                        int n = groupCount[0];
                        groupCount[0] = n + 1;
                        sibling = new JoinPathSegment(pathPart, parent, "g" + n);
                    } else {
                        sibling = new PathSegment(pathPart, parent);
                    }
                    paths.add(sibling);
                    parent = sibling;
                    paths = sibling.getChildren();
                    continue;
                }
                parent = path.get();
                paths = path.get().getChildren();
            }
        });
        return mappingPaths;
    }

    protected abstract Map<String, String> getSourceTableFieldTypes(String var1);
}

