/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.reporting.api;

import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.kie.kogito.persistence.reporting.database.DatabaseManager;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.Context;
import org.kie.kogito.persistence.reporting.model.Field;
import org.kie.kogito.persistence.reporting.model.JsonField;
import org.kie.kogito.persistence.reporting.model.Mapping;
import org.kie.kogito.persistence.reporting.model.MappingDefinition;
import org.kie.kogito.persistence.reporting.model.MappingDefinitions;
import org.kie.kogito.persistence.reporting.model.PartitionField;
import org.kie.kogito.persistence.reporting.service.MappingService;

public abstract class BaseMappingsApiV1<T, F extends Field, P extends PartitionField, J extends JsonField<T>, M extends Mapping<T, J>, D extends MappingDefinition<T, F, P, J, M>, S extends MappingDefinitions<T, F, P, J, M, D>, C extends Context<T, F, P, J, M>> {
    private MappingService<T, F, P, J, M, D> mappingService;
    private DatabaseManager<T, F, P, J, M, D, C> databaseManager;

    protected BaseMappingsApiV1() {
    }

    protected BaseMappingsApiV1(MappingService<T, F, P, J, M, D> mappingService, DatabaseManager<T, F, P, J, M, D, C> databaseManager) {
        this.mappingService = Objects.requireNonNull(mappingService);
        this.databaseManager = Objects.requireNonNull(databaseManager);
    }

    protected Response getAllMappingDefinitions() {
        List<D> result = this.mappingService.getAllMappingDefinitions();
        return Response.ok(this.buildMappingDefinitions(result)).build();
    }

    protected abstract S buildMappingDefinitions(List<D> var1);

    protected Response getMappingDefinitionById(String mappingId) {
        return this.retrieveMappingDefinitionById(mappingId).map(mapping -> Response.ok((Object)mapping).build()).orElseGet(this::buildBadRequestResponse);
    }

    protected Response createMappingDefinition(D definition) {
        this.mappingService.saveMappingDefinition(definition);
        this.databaseManager.createArtifacts(definition);
        return Response.ok().build();
    }

    protected Response deleteMappingDefinitionById(String mappingId) {
        Optional<D> definition = this.tryDeleteMappingDefinitionById(mappingId);
        definition.ifPresent(this.databaseManager::destroyArtifacts);
        return definition.map(d -> Response.ok().build()).orElseGet(this::buildBadRequestResponse);
    }

    private Optional<D> retrieveMappingDefinitionById(String mappingId) {
        try {
            return Optional.ofNullable(this.mappingService.getMappingDefinitionById(mappingId));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private Optional<D> tryDeleteMappingDefinitionById(String mappingId) {
        try {
            return Optional.ofNullable(this.mappingService.deleteMappingDefinitionById(mappingId));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private Response buildBadRequestResponse() {
        return Response.status((int)Response.Status.BAD_REQUEST.getStatusCode()).build();
    }
}

