/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.reporting.bootstrap;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.kie.kogito.persistence.reporting.bootstrap.BootstrapLoader;
import org.kie.kogito.persistence.reporting.database.DatabaseManager;
import org.kie.kogito.persistence.reporting.database.SchemaGenerationAction;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.Context;
import org.kie.kogito.persistence.reporting.model.Field;
import org.kie.kogito.persistence.reporting.model.JsonField;
import org.kie.kogito.persistence.reporting.model.Mapping;
import org.kie.kogito.persistence.reporting.model.MappingDefinition;
import org.kie.kogito.persistence.reporting.model.MappingDefinitions;
import org.kie.kogito.persistence.reporting.model.PartitionField;
import org.kie.kogito.persistence.reporting.service.MappingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseStartupHandler<T, F extends Field, P extends PartitionField, J extends JsonField<T>, M extends Mapping<T, J>, D extends MappingDefinition<T, F, P, J, M>, S extends MappingDefinitions<T, F, P, J, M, D>, C extends Context<T, F, P, J, M>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStartupHandler.class);
    private BootstrapLoader<T, F, P, J, M, D, S> loader;
    private DatabaseManager<T, F, P, J, M, D, C> databaseManager;
    private MappingService<T, F, P, J, M, D> mappingService;
    private SchemaGenerationAction action;

    protected BaseStartupHandler() {
    }

    protected BaseStartupHandler(BootstrapLoader<T, F, P, J, M, D, S> loader, DatabaseManager<T, F, P, J, M, D, C> databaseManager, MappingService<T, F, P, J, M, D> mappingService, SchemaGenerationAction action) {
        this.loader = Objects.requireNonNull(loader);
        this.mappingService = Objects.requireNonNull(mappingService);
        this.databaseManager = Objects.requireNonNull(databaseManager);
        this.action = Objects.requireNonNull(action);
    }

    protected void onStartup() {
        switch (this.action) {
            case NONE: {
                LOGGER.info("Database Schema Action is 'NONE'. Exiting.");
                break;
            }
            case DROP: {
                LOGGER.info("Database Schema Action is 'DROP'. Destroying existing database artifacts...");
                this.mappingService.getAllMappingDefinitions().forEach(this.databaseManager::destroyArtifacts);
                break;
            }
            case DROP_AND_CREATE: {
                LOGGER.info("Database Schema Action is 'DROP-AND-CREATE'. Destroying existing database artifacts...");
                this.mappingService.getAllMappingDefinitions().forEach(this.databaseManager::destroyArtifacts);
            }
            case CREATE: {
                LOGGER.info("Loading bootstrap Mapping Definitions...");
                this.loader.load().ifPresent(mappingDefinitions -> {
                    try {
                        ObjectMapper mapper = CloudEventUtils.Mapper.mapper();
                        LOGGER.info(String.format("Bootstrap Mapping Definitions are:%n%s", mapper.writerWithDefaultPrettyPrinter().writeValueAsString(mappingDefinitions)));
                    }
                    catch (JsonProcessingException jpe) {
                        LOGGER.error(String.format("Failed to load bootstrap Mapping Definitions: %s", jpe.getMessage()));
                    }
                    mappingDefinitions.getMappingDefinitions().forEach(definition -> {
                        try {
                            this.mappingService.saveMappingDefinition((MappingDefinition)definition);
                            this.databaseManager.createArtifacts((MappingDefinition)definition);
                        }
                        catch (Exception e) {
                            LOGGER.error(String.format("Failed to process MappingDefinition '%s'%n%s", definition.getMappingId(), e.getMessage()));
                        }
                    });
                });
            }
        }
    }
}

