/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.reporting.database.sqlbuilders;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.kie.kogito.persistence.reporting.database.sqlbuilders.Context;
import org.kie.kogito.persistence.reporting.model.BaseMappingDefinition;
import org.kie.kogito.persistence.reporting.model.Field;
import org.kie.kogito.persistence.reporting.model.JsonField;
import org.kie.kogito.persistence.reporting.model.Mapping;
import org.kie.kogito.persistence.reporting.model.PartitionField;
import org.kie.kogito.persistence.reporting.model.paths.PathSegment;

public abstract class BaseContext<T, F extends Field, P extends PartitionField, J extends JsonField<T>, M extends Mapping<T, J>>
extends BaseMappingDefinition<T, F, P, J, M>
implements Context<T, F, P, J, M> {
    private final List<PathSegment> mappingPaths;
    private final Map<String, String> sourceTableFieldTypes;

    protected BaseContext(String mappingId, String sourceTableName, String sourceTableJsonFieldName, List<F> sourceTableIdentityFields, List<P> sourceTablePartitionFields, String targetTableName, List<M> mappings, List<PathSegment> mappingPaths, Map<String, String> sourceTableFieldTypes) {
        super(mappingId, sourceTableName, sourceTableJsonFieldName, sourceTableIdentityFields, sourceTablePartitionFields, targetTableName, mappings);
        this.mappingPaths = Objects.requireNonNull(mappingPaths);
        this.sourceTableFieldTypes = Objects.requireNonNull(sourceTableFieldTypes);
    }

    @Override
    public List<PathSegment> getMappingPaths() {
        return this.mappingPaths;
    }

    @Override
    public Map<String, String> getSourceTableFieldTypes() {
        return this.sourceTableFieldTypes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseContext)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BaseContext that = (BaseContext)o;
        return this.getMappingPaths().equals(that.getMappingPaths()) && this.getSourceTableFieldTypes().equals(that.getSourceTableFieldTypes());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMappingPaths(), this.getSourceTableFieldTypes());
    }
}

