/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.reporting.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.kie.kogito.persistence.reporting.model.Field;
import org.kie.kogito.persistence.reporting.model.JsonField;
import org.kie.kogito.persistence.reporting.model.Mapping;
import org.kie.kogito.persistence.reporting.model.MappingDefinition;
import org.kie.kogito.persistence.reporting.model.PartitionField;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class BaseMappingDefinition<T, F extends Field, P extends PartitionField, J extends JsonField<T>, M extends Mapping<T, J>>
implements MappingDefinition<T, F, P, J, M> {
    public static final String MAPPING_ID_FIELD = "mappingId";
    public static final String SOURCE_TABLE_NAME_FIELD = "sourceTableName";
    public static final String SOURCE_TABLE_JSON_FIELD_NAME_FIELD = "sourceTableJsonFieldName";
    public static final String SOURCE_TABLE_IDENTITY_FIELDS_FIELD = "sourceTableIdentityFields";
    public static final String SOURCE_TABLE_PARTITION_FIELDS_FIELD = "sourceTablePartitionFields";
    public static final String TARGET_TABLE_NAME_FIELD = "targetTableName";
    public static final String FIELD_MAPPINGS_FIELD = "fieldMappings";
    @JsonProperty(value="mappingId")
    private String mappingId;
    @JsonProperty(value="sourceTableName")
    private String sourceTableName;
    @JsonProperty(value="sourceTableJsonFieldName")
    private String sourceTableJsonFieldName;
    @JsonProperty(value="sourceTableIdentityFields")
    private List<F> sourceTableIdentityFields;
    @JsonProperty(value="sourceTablePartitionFields")
    private List<P> sourceTablePartitionFields;
    @JsonProperty(value="targetTableName")
    private String targetTableName;
    @JsonProperty(value="fieldMappings")
    private List<M> fieldMappings;

    protected BaseMappingDefinition() {
    }

    protected BaseMappingDefinition(String mappingId, String sourceTableName, String sourceTableJsonFieldName, List<F> sourceTableIdentityFields, List<P> sourceTablePartitionFields, String targetTableName, List<M> fieldMappings) {
        this.mappingId = Objects.requireNonNull(mappingId);
        this.sourceTableName = Objects.requireNonNull(sourceTableName);
        this.sourceTableJsonFieldName = Objects.requireNonNull(sourceTableJsonFieldName);
        this.sourceTableIdentityFields = Objects.requireNonNull(sourceTableIdentityFields);
        this.sourceTablePartitionFields = Objects.requireNonNull(sourceTablePartitionFields);
        this.targetTableName = Objects.requireNonNull(targetTableName);
        this.fieldMappings = Objects.requireNonNull(fieldMappings);
    }

    @Override
    public String getMappingId() {
        return this.mappingId;
    }

    @Override
    public String getSourceTableName() {
        return this.sourceTableName;
    }

    @Override
    public String getSourceTableJsonFieldName() {
        return this.sourceTableJsonFieldName;
    }

    @Override
    public List<F> getSourceTableIdentityFields() {
        return this.sourceTableIdentityFields;
    }

    @Override
    public List<P> getSourceTablePartitionFields() {
        return this.sourceTablePartitionFields;
    }

    @Override
    public String getTargetTableName() {
        return this.targetTableName;
    }

    @Override
    public List<M> getFieldMappings() {
        return this.fieldMappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseMappingDefinition)) {
            return false;
        }
        BaseMappingDefinition that = (BaseMappingDefinition)o;
        return this.getMappingId().equals(that.getMappingId()) && this.getSourceTableName().equals(that.getSourceTableName()) && this.getSourceTableJsonFieldName().equals(that.getSourceTableJsonFieldName()) && this.getSourceTableIdentityFields().equals(that.getSourceTableIdentityFields()) && Objects.equals(this.getSourceTablePartitionFields(), that.getSourceTablePartitionFields()) && this.getTargetTableName().equals(that.getTargetTableName()) && this.getFieldMappings().equals(that.getFieldMappings());
    }

    public int hashCode() {
        return Objects.hash(this.getMappingId(), this.getSourceTableName(), this.getSourceTableJsonFieldName(), this.getSourceTableIdentityFields(), this.getSourceTablePartitionFields(), this.getTargetTableName(), this.getFieldMappings());
    }
}

