/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testscorecard;

import java.util.Collections;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.PMML_MODEL;
import org.kie.pmml.models.drools.scorecard.model.KiePMMLScorecardModel;

public class SimpleScorecard extends KiePMMLScorecardModel {

    public SimpleScorecard() {
        super("SimpleScorecard", Collections.emptyList());
        targetField = "score";
        pmmlMODEL = org.kie.pmml.commons.model.enums.PMML_MODEL.SCORECARD_MODEL;
        miningFunction = org.kie.pmml.commons.model.enums.MINING_FUNCTION.REGRESSION;
        outputFields.add(KiePMMLOutputField.builder("Score", Collections.emptyList()).withRank(1).withResultFeature(org.kie.pmml.commons.model.enums.RESULT_FEATURE.PREDICTED_VALUE).build());
        outputFields.add(KiePMMLOutputField.builder("Reason Code 1", Collections.emptyList()).withRank(1).withResultFeature(org.kie.pmml.commons.model.enums.RESULT_FEATURE.REASON_CODE).build());
        outputFields.add(KiePMMLOutputField.builder("Reason Code 2", Collections.emptyList()).withRank(2).withResultFeature(org.kie.pmml.commons.model.enums.RESULT_FEATURE.REASON_CODE).build());
        fieldTypeMap.put("score", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "SCORE"));
        fieldTypeMap.put("input2", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "INPUT2"));
        fieldTypeMap.put("input1", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "INPUT1"));
    }

    @Override
    public String getKModulePackageName() {
        return "testscorecard";
    }
}
