/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testtree;

import java.util.Collections;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.PMML_MODEL;
import org.kie.pmml.models.drools.tree.model.KiePMMLTreeModel;

public class SampleMine extends KiePMMLTreeModel {

    public SampleMine() {
        super("SampleMine", Collections.emptyList(), "null");
        targetField = "decision";
        pmmlMODEL = org.kie.pmml.commons.model.enums.PMML_MODEL.TREE_MODEL;
        miningFunction = org.kie.pmml.commons.model.enums.MINING_FUNCTION.CLASSIFICATION;
        outputFields.add(KiePMMLOutputField.builder("weatherdecision", Collections.emptyList()).withRank(1).withTargetField("decision").withResultFeature(org.kie.pmml.commons.model.enums.RESULT_FEATURE.PREDICTED_VALUE).build());
        fieldTypeMap.put("decision", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("string", "DECISION"));
        fieldTypeMap.put("temperature", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "TEMPERATURE"));
        fieldTypeMap.put("humidity", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "HUMIDITY"));
    }

    @Override
    public String getKModulePackageName() {
        return "testtree";
    }
}
