/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testminingmodel.predicatesminingsegmentation.predicatesminingsegment0;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;

public class KiePMMLRegressionTableRegression2 extends KiePMMLRegressionTable {

    public KiePMMLRegressionTableRegression2() {
        intercept = -22.1;
        targetField = "categoricalResult";
        categoricalFunctionMap.put("categoricalY", this::evaluateCategoricalPredictor1);
        categoricalFunctionMap.put("categoricalX", this::evaluateCategoricalPredictor2);
    }

    @Override
    public Object getTargetCategory() {
        return null;
    }

    @Override
    protected void updateResult(final AtomicReference<Double> toUpdate) {
    }

    @Override
    protected void populateOutputFieldsMapWithResult(final Object result) {
        outputFieldsMap.put("Predicted_result", result);
    }

    private double evaluateCategoricalPredictor1(Object input) {
        if (Objects.equals("classA", input))
            return 0;
        else if (Objects.equals("classB", input))
            return 20;
        else if (Objects.equals("classC", input))
            return 40;
        else
            return 0.0;
    }

    private double evaluateCategoricalPredictor2(Object input) {
        if (Objects.equals("red", input))
            return 5.5;
        else if (Objects.equals("green", input))
            return 15;
        else if (Objects.equals("blue", input))
            return 12;
        else if (Objects.equals("orange", input))
            return 5.5;
        else if (Objects.equals("yellow", input))
            return -100.25;
        else
            return 0.0;
    }
}
