/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testminingmodel.predicatesminingsegmentation.predicatesminingsegment1;

import java.util.Collections;
import org.kie.pmml.commons.model.KiePMMLOutputField;
import org.kie.pmml.commons.model.enums.PMML_MODEL;
import org.kie.pmml.models.drools.scorecard.model.KiePMMLScorecardModel;

public class SampleScore extends KiePMMLScorecardModel {

    public SampleScore() {
        super("Sample Score", Collections.emptyList());
        targetField = "overallScore";
        pmmlMODEL = org.kie.pmml.commons.model.enums.PMML_MODEL.SCORECARD_MODEL;
        miningFunction = org.kie.pmml.commons.model.enums.MINING_FUNCTION.REGRESSION;
        outputFields.add(KiePMMLOutputField.builder("calculatedScore", Collections.emptyList()).withRank(1).withTargetField("overallScore").withResultFeature(org.kie.pmml.commons.model.enums.RESULT_FEATURE.PREDICTED_VALUE).build());
        fieldTypeMap.put("residenceState", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("string", "RESIDENCESTATE"));
        fieldTypeMap.put("validLicense", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("boolean", "VALIDLICENSE"));
        fieldTypeMap.put("occupation", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("string", "OCCUPATION"));
        fieldTypeMap.put("categoricalY", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("string", "CATEGORICALY"));
        fieldTypeMap.put("categoricalX", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("string", "CATEGORICALX"));
        fieldTypeMap.put("overallScore", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "OVERALLSCORE"));
        fieldTypeMap.put("variable", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "VARIABLE"));
        fieldTypeMap.put("categoricalResult", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "CATEGORICALRESULT"));
        fieldTypeMap.put("age", new org.kie.pmml.models.drools.tuples.KiePMMLOriginalTypeGeneratedType("double", "AGE"));
    }

    @Override
    public String getKModulePackageName() {
        return "testminingmodel.predicatesminingsegmentation.predicatesminingsegment1";
    }
}
