/*
 * Copyright 2020 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package testregression;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.kie.pmml.models.regression.model.KiePMMLRegressionTable;

public class KiePMMLRegressionTableRegression4 extends KiePMMLRegressionTable {

    public KiePMMLRegressionTableRegression4() {
        intercept = 0.5;
        targetField = "fld4";
        numericFunctionMap.put("fld2", this::evaluateNumericPredictor2);
        numericFunctionMap.put("fld1", this::evaluateNumericPredictor1);
        categoricalFunctionMap.put("fld3", this::evaluateCategoricalPredictor1);
    }

    @Override
    public Object getTargetCategory() {
        return null;
    }

    @Override
    protected void updateResult(final AtomicReference<Double> toUpdate) {
    }

    @Override
    protected void populateOutputFieldsMapWithResult(final Object result) {
        outputFieldsMap.put("result", result);
    }

    private double evaluateNumericPredictor1(double input) {
        double coefficient = 5.0;
        double exponent = 2.0;
        // Considering exponent because it is != 1
        return Math.pow(input, exponent) * coefficient;
    }

    private double evaluateNumericPredictor2(double input) {
        double coefficient = 2.0;
        // Ignoring exponent because it is 1
        return input * coefficient;
    }

    private double evaluateCategoricalPredictor1(Object input) {
        if (Objects.equals("x", input))
            return -3;
        else if (Objects.equals("y", input))
            return 3;
        else
            return 0.0;
    }
}
