/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.kogito.springboot.example;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.pmml.kogito.springboot.example.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class SimpleScorecardTest {
    @LocalServerPort
    private int port;

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    public void testEvaluateSimpleScorecard() {
        String inputData = "{\"input1\":5.0, \"input2\":-10.0}";
        Object resultVariables = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(inputData).when().post("/SimpleScorecard", new Object[0])).then()).statusCode(200)).body("correlationId", Matchers.is((Matcher)new IsNull()), new Object[0])).body("segmentationId", Matchers.is((Matcher)new IsNull()), new Object[0])).body("segmentId", Matchers.is((Matcher)new IsNull()), new Object[0])).body("segmentIndex", Matchers.is((Object)0), new Object[0])).body("resultCode", Matchers.is((Object)"OK"), new Object[0])).body("resultObjectName", Matchers.is((Object)"score"), new Object[0])).extract().path("resultVariables", new String[0]);
        Assertions.assertNotNull((Object)resultVariables);
        Assertions.assertTrue((boolean)(resultVariables instanceof Map));
        Map mappedResultVariables = (Map)resultVariables;
        Assertions.assertTrue((boolean)mappedResultVariables.containsKey("score"));
        Assertions.assertEquals((Object)Float.valueOf(-15.0f), mappedResultVariables.get("score"));
        Assertions.assertTrue((boolean)mappedResultVariables.containsKey("Score"));
        Assertions.assertEquals((Object)Float.valueOf(-15.0f), mappedResultVariables.get("Score"));
        Assertions.assertTrue((boolean)mappedResultVariables.containsKey("Reason Code 1"));
        Assertions.assertEquals((Object)"Input1ReasonCode", mappedResultVariables.get("Reason Code 1"));
        Assertions.assertTrue((boolean)mappedResultVariables.containsKey("Reason Code 2"));
        Assertions.assertEquals((Object)"Input2ReasonCode", mappedResultVariables.get("Reason Code 2"));
    }
}

