/*
 * Decompiled with CFR 0.152.
 */
package org.kie.pmml.kogito.springboot.example;

import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.pmml.kogito.springboot.example.KogitoSpringbootApplication;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.server.LocalServerPort;
import org.springframework.test.annotation.DirtiesContext;

@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.RANDOM_PORT, classes={KogitoSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class MiningModelTest {
    @LocalServerPort
    private int port;

    @BeforeEach
    public void setUp() {
        RestAssured.port = this.port;
    }

    @Test
    public void testEvaluatePredicatesMining() {
        String inputData = "{\"residenceState\":\"AP\", \"validLicense\":true, \"occupation\":\"ASTRONAUT\", \"categoricalY\":\"classA\", \"categoricalX\":\"red\", \"variable\":6.6, \"age\":25.0}";
        Object resultVariables = ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(inputData).when().post("/PredicatesMining", new Object[0])).then()).statusCode(200)).body("correlationId", Matchers.is((Matcher)new IsNull()), new Object[0])).body("segmentationId", Matchers.is((Matcher)new IsNull()), new Object[0])).body("segmentId", Matchers.is((Matcher)new IsNull()), new Object[0])).body("segmentIndex", Matchers.is((Object)0), new Object[0])).body("resultCode", Matchers.is((Object)"OK"), new Object[0])).body("resultObjectName", Matchers.is((Object)"categoricalResult"), new Object[0])).extract().path("resultVariables", new String[0]);
        Assertions.assertNotNull((Object)resultVariables);
        Assertions.assertTrue((boolean)(resultVariables instanceof Map));
        Map mappedResultVariables = (Map)resultVariables;
        Assertions.assertTrue((boolean)mappedResultVariables.containsKey("categoricalResult"));
        Assertions.assertEquals((Object)Float.valueOf(1.3816667f), mappedResultVariables.get("categoricalResult"));
    }
}

