/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.acme.travels.PersonsModel;
import org.acme.travels.PersonsModelInput;
import org.acme.travels.PersonsModelOutput;
import org.acme.travels.Persons_5_TaskInput;
import org.acme.travels.Persons_5_TaskOutput;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/persons")
@Component
public class PersonsResource {
    @Autowired
    @Qualifier(value="persons")
    Process<PersonsModel> process;
    @Autowired
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createResource_persons(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @QueryParam(value="businessKey") String businessKey, @Valid @NotNull PersonsModelInput resource) {
        return (Response)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            PersonsModelInput inputModel = resource != null ? resource : new PersonsModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder().path(pi.id());
            return Response.created((URI)uriBuilder.build(new Object[0])).entity((Object)((PersonsModel)pi.checkError().variables()).toOutput()).build();
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<PersonsModelOutput> getResources_persons() {
        return this.process.instances().values().stream().map(pi -> ((PersonsModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public PersonsModelOutput getResource_persons(@PathParam(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ((PersonsModel)pi.variables()).toOutput()).orElseThrow(() -> new NotFoundException());
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public PersonsModelOutput deleteResource_persons(@PathParam(value="id") String id) {
        return (PersonsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((PersonsModel)pi.checkError().variables()).toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PersonsModelOutput updateModel_persons(@PathParam(value="id") String id, PersonsModel resource) {
        return (PersonsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((PersonsModel)pi.updateVariables((Object)resource)).toOutput()).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public List<WorkItem> getTasks_persons(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of((String)user, (Collection)groups))).orElseThrow(() -> new NotFoundException());
    }

    @POST
    @Path(value="/{id}/ChildrenHandling/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public PersonsModelOutput completeTask_ChildrenHandling_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, Persons_5_TaskOutput model) {
        return (PersonsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ((PersonsModel)pi.variables()).toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path(value="/{id}/ChildrenHandling/{workItemId}")
    @Produces(value={"application/json"})
    public Persons_5_TaskInput getTask_ChildrenHandling_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> Persons_5_TaskInput.from((WorkItem)pi.workItem(workItemId, Policies.of((String)user, (Collection)groups)))).orElseThrow(() -> new NotFoundException());
    }

    @GET
    @Path(value="ChildrenHandling/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_ChildrenHandling_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ChildrenHandling");
    }

    @GET
    @Path(value="/{id}/ChildrenHandling/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_ChildrenHandling_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"ChildrenHandling"));
    }

    @DELETE
    @Path(value="/{id}/ChildrenHandling/{workItemId}")
    @Produces(value={"application/json"})
    public PersonsModelOutput abortTask_ChildrenHandling_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return (PersonsModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ((PersonsModel)pi.variables()).toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }
}

