/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.management;

import org.kie.kogito.Application;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.management.BaseProcessInstanceManagementResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/management/processes"})
public class ProcessInstanceManagementRestController
extends BaseProcessInstanceManagementResource<ResponseEntity> {
    @Autowired
    public ProcessInstanceManagementRestController(Processes processes, Application application) {
        super(processes, application);
    }

    public <R> ResponseEntity buildOkResponse(R body) {
        return ResponseEntity.ok(body);
    }

    public ResponseEntity badRequestResponse(String message) {
        return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)message);
    }

    public ResponseEntity notFoundResponse(String message) {
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)message);
    }

    @GetMapping(value={"{processId}/instances/{processInstanceId}/error"}, produces={"application/json"})
    public ResponseEntity getInstanceInError(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId) {
        return (ResponseEntity)this.doGetInstanceInError(processId, processInstanceId);
    }

    @GetMapping(value={"{processId}/instances/{processInstanceId}/nodeInstances"}, produces={"application/json"})
    public ResponseEntity getWorkItemsInProcessInstance(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId) {
        return (ResponseEntity)this.doGetWorkItemsInProcessInstance(processId, processInstanceId);
    }

    @PostMapping(value={"{processId}/instances/{processInstanceId}/retrigger"}, produces={"application/json"})
    public ResponseEntity retriggerInstanceInError(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId) {
        return (ResponseEntity)this.doRetriggerInstanceInError(processId, processInstanceId);
    }

    @PostMapping(value={"{processId}/instances/{processInstanceId}/skip"}, produces={"application/json"})
    public ResponseEntity skipInstanceInError(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId) {
        return (ResponseEntity)this.doSkipInstanceInError(processId, processInstanceId);
    }

    @PostMapping(value={"{processId}/instances/{processInstanceId}/nodes/{nodeId}"}, produces={"application/json"})
    public ResponseEntity triggerNodeInstanceId(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="nodeId") String nodeId) {
        return (ResponseEntity)this.doTriggerNodeInstanceId(processId, processInstanceId, nodeId);
    }

    @PostMapping(value={"{processId}/instances/{processInstanceId}/nodeInstances/{nodeInstanceId}"}, produces={"application/json"})
    public ResponseEntity retriggerNodeInstanceId(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="nodeInstanceId") String nodeInstanceId) {
        return (ResponseEntity)this.doRetriggerNodeInstanceId(processId, processInstanceId, nodeInstanceId);
    }

    @DeleteMapping(value={"{processId}/instances/{processInstanceId}/nodeInstances/{nodeInstanceId}"}, produces={"application/json"})
    public ResponseEntity cancelNodeInstanceId(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId, @PathVariable(value="nodeInstanceId") String nodeInstanceId) {
        return (ResponseEntity)this.doCancelNodeInstanceId(processId, processInstanceId, nodeInstanceId);
    }

    @DeleteMapping(value={"{processId}/instances/{processInstanceId}"}, produces={"application/json"})
    public ResponseEntity cancelProcessInstanceId(@PathVariable(value="processId") String processId, @PathVariable(value="processInstanceId") String processInstanceId) {
        return (ResponseEntity)this.doCancelProcessInstanceId(processId, processInstanceId);
    }
}

