/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.management.exceptions;

import org.kie.kogito.process.NodeInstanceNotFoundException;
import org.kie.kogito.process.NodeNotFoundException;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.ProcessInstanceNotFoundException;
import org.kie.kogito.process.VariableViolationException;
import org.kie.kogito.process.management.exceptions.BaseExceptionHandler;
import org.kie.kogito.process.workitem.InvalidLifeCyclePhaseException;
import org.kie.kogito.process.workitem.InvalidTransitionException;
import org.kie.kogito.process.workitem.NotAuthorizedException;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
public class ExceptionsHandler
extends BaseExceptionHandler<ResponseEntity> {
    protected <R> ResponseEntity badRequest(R body) {
        return ResponseEntity.badRequest().contentType(MediaType.APPLICATION_JSON).body(body);
    }

    protected <R> ResponseEntity conflict(R body) {
        return ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).contentType(MediaType.APPLICATION_JSON).body(body);
    }

    protected <R> ResponseEntity internalError(R body) {
        return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body(body);
    }

    protected <R> ResponseEntity notFound(R body) {
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).contentType(MediaType.APPLICATION_JSON).body(body);
    }

    protected <R> ResponseEntity forbidden(R body) {
        return ResponseEntity.status((HttpStatus)HttpStatus.FORBIDDEN).contentType(MediaType.APPLICATION_JSON).body(body);
    }

    @ExceptionHandler(value={InvalidLifeCyclePhaseException.class})
    public ResponseEntity toResponse(InvalidLifeCyclePhaseException exception) {
        return (ResponseEntity)this.mapException((Exception)exception);
    }

    @ExceptionHandler(value={InvalidTransitionException.class})
    public ResponseEntity toResponse(InvalidTransitionException exception) {
        return (ResponseEntity)this.mapException((Exception)exception);
    }

    @ExceptionHandler(value={NodeInstanceNotFoundException.class})
    public ResponseEntity toResponse(NodeInstanceNotFoundException exception) {
        return (ResponseEntity)this.mapException((Exception)exception);
    }

    @ExceptionHandler(value={NodeNotFoundException.class})
    public ResponseEntity toResponse(NodeNotFoundException exception) {
        return (ResponseEntity)this.mapException((Exception)exception);
    }

    @ExceptionHandler(value={NotAuthorizedException.class})
    public ResponseEntity toResponse(NotAuthorizedException exception) {
        return (ResponseEntity)this.mapException((Exception)exception);
    }

    @ExceptionHandler(value={ProcessInstanceDuplicatedException.class})
    public ResponseEntity<Object> toResponse(ProcessInstanceDuplicatedException exception) {
        return (ResponseEntity)this.mapException((Exception)exception);
    }

    @ExceptionHandler(value={ProcessInstanceExecutionException.class})
    public ResponseEntity toResponse(ProcessInstanceExecutionException exception) {
        return (ResponseEntity)this.mapException((Exception)exception);
    }

    @ExceptionHandler(value={ProcessInstanceNotFoundException.class})
    public ResponseEntity toResponse(ProcessInstanceNotFoundException exception) {
        return (ResponseEntity)this.mapException((Exception)exception);
    }

    @ExceptionHandler(value={VariableViolationException.class})
    public ResponseEntity toResponse(VariableViolationException exception) {
        return (ResponseEntity)this.mapException((Exception)exception);
    }
}

