/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.acme.travels.TravellersModel;
import org.acme.travels.TravellersModelInput;
import org.acme.travels.TravellersModelOutput;
import org.kie.kogito.Application;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/travellers")
@Component
public class TravellersResource {
    @Autowired
    @Qualifier(value="travellers")
    Process<TravellersModel> process;
    @Autowired
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createResource_travellers(@Context HttpHeaders httpHeaders, @Context UriInfo uriInfo, @QueryParam(value="businessKey") String businessKey, @Valid @NotNull TravellersModelInput resource) {
        return (Response)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            TravellersModelInput inputModel = resource != null ? resource : new TravellersModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            UriBuilder uriBuilder = uriInfo.getAbsolutePathBuilder().path(pi.id());
            return Response.created((URI)uriBuilder.build(new Object[0])).entity((Object)((TravellersModel)pi.checkError().variables()).toOutput()).build();
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<TravellersModelOutput> getResources_travellers() {
        return this.process.instances().values().stream().map(pi -> ((TravellersModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public TravellersModelOutput getResource_travellers(@PathParam(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ((TravellersModel)pi.variables()).toOutput()).orElseThrow(() -> new NotFoundException());
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public TravellersModelOutput deleteResource_travellers(@PathParam(value="id") String id) {
        return (TravellersModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((TravellersModel)pi.checkError().variables()).toOutput();
        }).orElseThrow(() -> new NotFoundException()));
    }

    @PUT
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TravellersModelOutput updateModel_travellers(@PathParam(value="id") String id, TravellersModel resource) {
        return (TravellersModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((TravellersModel)pi.updateVariables((Object)resource)).toOutput()).orElseThrow(() -> new NotFoundException()));
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public List<WorkItem> getTasks_travellers(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of((String)user, (Collection)groups))).orElseThrow(() -> new NotFoundException());
    }
}

