/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.hamcrest.CoreMatchers;
import org.junit.jupiter.api.Test;
import org.kie.kogito.process.JobServiceQuarkusTestResource;

@QuarkusTest
@QuarkusTestResource(value=JobServiceQuarkusTestResource.class)
public class ProcessTimerIT {
    private static final String TIMERS = "timers";
    private static final String TIMERS_CYCLE = "timerscycle";
    private static final String TIMERS_ON_TASK = "timersOnTask";

    @Test
    public void testTimers() {
        String id = this.createTimer(new Delay("PT02S"), TIMERS);
        String id2 = this.getTimerById(id, TIMERS);
        Assertions.assertThat((String)id).isEqualTo((Object)id2);
        Awaitility.with().pollDelay(2L, TimeUnit.SECONDS).atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> this.getTimerWithStatusCode(id, 204, TIMERS));
    }

    @Test
    public void testCancelTimer() {
        String id = this.createTimer(new Delay("PT030S"), TIMERS);
        Object id2 = this.deleteTimer(id, TIMERS);
        Assertions.assertThat((String)id).isEqualTo(id2);
        this.getTimerWithStatusCode(id, 204, TIMERS);
    }

    @Test
    public void testTimerCycle() {
        String id = this.createTimer(new Delay("R2/PT1S"), TIMERS_CYCLE);
        String id2 = this.getTimerById(id, TIMERS_CYCLE);
        Assertions.assertThat((String)id).isEqualTo(id2);
        Awaitility.with().pollDelay(2L, TimeUnit.SECONDS).atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> this.getTimerWithStatusCode(id, 204, TIMERS));
    }

    @Test
    public void testDeleteTimerCycle() {
        String id = this.createTimer(new Delay("R20/PT1S"), TIMERS_CYCLE);
        String id2 = this.getTimerById(id, TIMERS_CYCLE);
        Assertions.assertThat((String)id).isEqualTo(id2);
        this.deleteTimer(id, TIMERS_CYCLE);
    }

    @Test
    public void testBoundaryTimersOnTask() {
        String id = this.createTimer(new Delay("PT02S"), TIMERS_ON_TASK);
        String id2 = this.getTimerById(id, TIMERS_ON_TASK);
        Assertions.assertThat((String)id).isEqualTo(id2);
        Awaitility.with().pollDelay(2L, TimeUnit.SECONDS).atMost(3L, TimeUnit.SECONDS).untilAsserted(() -> this.getTimerWithStatusCode(id, 204, TIMERS_ON_TASK));
    }

    @Test
    public void testDeleteBoundaryTimersOnTask() {
        String id = this.createTimer(new Delay("PT030S"), TIMERS_ON_TASK);
        String id2 = this.getTimerById(id, TIMERS_ON_TASK);
        Assertions.assertThat((String)id).isEqualTo(id2);
        this.deleteTimer(id, TIMERS_ON_TASK);
    }

    private ValidatableResponse getTimerWithStatusCode(String id, int code, String path) {
        return (ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().get("/" + path + "/{id}", new Object[]{id})).then()).statusCode(code);
    }

    private String createTimer(Delay delay, String path) {
        return (String)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).accept(ContentType.JSON).body((Object)delay).when().post("/" + path, new Object[0])).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
    }

    private String getTimerById(String id, String path) {
        return (String)((ValidatableResponse)this.getTimerWithStatusCode(id, 200, path).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
    }

    private Object deleteTimer(String id, String path) {
        return ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).when().delete("/" + path + "/{id}", new Object[]{id})).then()).statusCode(200)).body("id", CoreMatchers.notNullValue(), new Object[0])).extract().path("id", new String[0]);
    }

    private class Delay {
        private String delay;

        public Delay(String delay) {
            this.delay = delay;
        }

        public String getDelay() {
            return this.delay;
        }
    }
}

