/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.acme.travels.CompleteProcessListener;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.kogito.Application;
import org.kie.kogito.Model;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.impl.CachedProcessEventListenerConfig;
import org.kie.kogito.tests.KogitoInfinispanSpringbootApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(webEnvironment=SpringBootTest.WebEnvironment.DEFINED_PORT, classes={KogitoInfinispanSpringbootApplication.class})
@DirtiesContext(classMode=DirtiesContext.ClassMode.AFTER_EACH_TEST_METHOD)
public class TimersProcessTest {
    @Autowired
    Application app;

    @Test
    public void testTimersProcess() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        ((CachedProcessEventListenerConfig)this.app.config().process().processEventListeners()).register((ProcessEventListener)new CompleteProcessListener(latch));
        Process timersProcess = this.app.processes().processById("timers");
        Assert.assertNotNull((Object)timersProcess);
        Model m = (Model)timersProcess.createModel();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("delay", "PT3S");
        m.fromMap(parameters);
        ProcessInstance processInstance = timersProcess.createInstance(m);
        processInstance.start();
        Assert.assertEquals((long)1L, (long)processInstance.status());
        latch.await(1L, TimeUnit.MINUTES);
        Optional exists = timersProcess.instances().findById(processInstance.id());
        Assert.assertFalse((boolean)exists.isPresent());
    }
}

