/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.acme.travels.TimersOnTaskModel;
import org.acme.travels.TimersOnTaskModelInput;
import org.acme.travels.TimersOnTaskModelOutput;
import org.acme.travels.TimersOnTask_1_TaskInput;
import org.acme.travels.TimersOnTask_1_TaskOutput;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Path(value="/timersOnTask")
@Component
public class TimersOnTaskResource {
    @Autowired
    @Qualifier(value="timersOnTask")
    Process<TimersOnTaskModel> process;
    @Autowired
    Application application;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public TimersOnTaskModelOutput createResource_timersOnTask(@Context HttpHeaders httpHeaders, @QueryParam(value="businessKey") String businessKey, @Valid @NotNull TimersOnTaskModelInput resource) {
        return (TimersOnTaskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            TimersOnTaskModelInput inputModel = resource != null ? resource : new TimersOnTaskModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            String startFromNode = httpHeaders.getHeaderString("X-KOGITO-StartFromNode");
            if (startFromNode != null) {
                pi.startFrom(startFromNode);
            } else {
                pi.start();
            }
            return ((TimersOnTaskModel)pi.checkError().variables()).toOutput();
        });
    }

    @GET
    @Produces(value={"application/json"})
    public List<TimersOnTaskModelOutput> getResources_timersOnTask() {
        return this.process.instances().values().stream().map(pi -> ((TimersOnTaskModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public TimersOnTaskModelOutput getResource_timersOnTask(@PathParam(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> ((TimersOnTaskModel)pi.variables()).toOutput()).orElse(null);
    }

    @DELETE
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public TimersOnTaskModelOutput deleteResource_timersOnTask(@PathParam(value="id") String id) {
        return (TimersOnTaskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((TimersOnTaskModel)pi.checkError().variables()).toOutput();
        }).orElse(null));
    }

    @POST
    @Path(value="/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TimersOnTaskModelOutput updateModel_timersOnTask(@PathParam(value="id") String id, TimersOnTaskModel resource) {
        return (TimersOnTaskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((TimersOnTaskModel)pi.updateVariables((Object)resource)).toOutput()).orElse(null));
    }

    @GET
    @Path(value="/{id}/tasks")
    @Produces(value={"application/json"})
    public Map<String, String> getTasks_timersOnTask(@PathParam(value="id") String id, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(this.policies(user, groups))).map(l -> l.stream().collect(Collectors.toMap(WorkItem::getId, WorkItem::getName))).orElse(null);
    }

    protected Policy[] policies(String user, List<String> groups) {
        if (user == null) {
            return new Policy[0];
        }
        StaticIdentityProvider identity = null;
        if (user != null) {
            identity = new StaticIdentityProvider(user, groups);
        }
        return new Policy[]{SecurityPolicy.of((IdentityProvider)identity)};
    }

    @POST
    @Path(value="/{id}/work/{workItemId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public TimersOnTaskModelOutput completeTask_work_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="complete") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups, TimersOnTask_1_TaskOutput model) {
        return (TimersOnTaskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])this.policies(user, groups)));
            return ((TimersOnTaskModel)pi.variables()).toOutput();
        }).orElse(null));
    }

    @GET
    @Path(value="/{id}/work/{workItemId}")
    @Produces(value={"application/json"})
    public TimersOnTask_1_TaskInput getTask_work_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> TimersOnTask_1_TaskInput.from((WorkItem)pi.workItem(workItemId, this.policies(user, groups)))).orElse(null);
    }

    @GET
    @Path(value="work/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchema_work_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"work");
    }

    @GET
    @Path(value="/{id}/work/{workItemId}/schema")
    @Produces(value={"application/json"})
    public Map<String, Object> getSchemaAndPhases_work_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)workItemId, (Policy[])this.policies(user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"work"));
    }

    @DELETE
    @Path(value="/{id}/work/{workItemId}")
    @Produces(value={"application/json"})
    public TimersOnTaskModelOutput abortTask_work_0(@PathParam(value="id") String id, @PathParam(value="workItemId") String workItemId, @QueryParam(value="phase") @DefaultValue(value="abort") String phase, @QueryParam(value="user") String user, @QueryParam(value="group") List<String> groups) {
        return (TimersOnTaskModelOutput)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(workItemId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])this.policies(user, groups)));
            return ((TimersOnTaskModel)pi.variables()).toOutput();
        }).orElse(null));
    }
}

