/*
 * Decompiled with CFR 0.152.
 */
package org.acme.travels;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.acme.travels.ApprovalsModel;
import org.acme.travels.ApprovalsModelInput;
import org.acme.travels.ApprovalsModelOutput;
import org.acme.travels.Approvals_1_TaskInput;
import org.acme.travels.Approvals_1_TaskOutput;
import org.acme.travels.Approvals_2_TaskInput;
import org.acme.travels.Approvals_2_TaskOutput;
import org.jbpm.process.instance.impl.humantask.HumanTaskHelper;
import org.jbpm.process.instance.impl.humantask.HumanTaskTransition;
import org.jbpm.util.JsonSchemaUtil;
import org.kie.kogito.Application;
import org.kie.kogito.MapOutput;
import org.kie.kogito.internal.process.runtime.KogitoWorkItem;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.workitem.Attachment;
import org.kie.kogito.process.workitem.AttachmentInfo;
import org.kie.kogito.process.workitem.Comment;
import org.kie.kogito.process.workitem.Policies;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.process.workitem.Transition;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/approvals"})
@Component
public class ApprovalsResource {
    @Autowired
    @Qualifier(value="approvals")
    Process<ApprovalsModel> process;
    @Autowired
    Application application;

    @PostMapping(produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> createResource_approvals(@RequestHeader HttpHeaders httpHeaders, @RequestParam(value="businessKey", required=false) String businessKey, @RequestBody(required=false) @Valid @NotNull ApprovalsModelInput resource, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            ApprovalsModelInput inputModel = resource != null ? resource : new ApprovalsModelInput();
            ProcessInstance pi = this.process.createInstance(businessKey, (Object)inputModel.toModel());
            List startFromNode = httpHeaders.get((Object)"X-KOGITO-StartFromNode");
            if (startFromNode != null && !startFromNode.isEmpty()) {
                pi.startFrom((String)startFromNode.get(0));
            } else {
                pi.start();
            }
            UriComponents uriComponents = uriComponentsBuilder.path("/approvals/{id}").buildAndExpand(new Object[]{pi.id()});
            URI location = uriComponents.toUri();
            return ResponseEntity.created((URI)location).body((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        });
    }

    @GetMapping(produces={"application/json"})
    public List<ApprovalsModelOutput> getResources_approvals() {
        return this.process.instances().values().stream().map(pi -> ((ApprovalsModel)pi.variables()).toOutput()).collect(Collectors.toList());
    }

    @GetMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> getResource_approvals(@PathVariable(value="id") String id) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(m -> ResponseEntity.ok((Object)((ApprovalsModel)m.variables()).toOutput())).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @DeleteMapping(value={"/{id}"}, produces={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> deleteResource_approvals(@PathVariable(value="id") String id) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.abort();
            return ((ApprovalsModel)pi.checkError().variables()).toOutput();
        }).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PutMapping(value={"/{id}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> updateModel_approvals(@PathVariable(value="id") String id, @RequestBody(required=false) ApprovalsModel resource) {
        return ((Optional)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ((ApprovalsModel)pi.updateVariables((Object)resource)).toOutput()).map(m -> ResponseEntity.ok((Object)m)))).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/{id}/tasks"}, produces={"application/json"})
    public ResponseEntity<List<WorkItem>> getTasks_approvals(@PathVariable(value="id") String id, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id, ProcessInstanceReadMode.READ_ONLY).map(pi -> pi.workItems(Policies.of((String)user, (Collection)groups))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping(value={"/{id}/firstLineApproval/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> taskTransition_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Approvals_1_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/firstLineApproval/{taskId}"}, consumes={"application/json"})
    public ResponseEntity<Approvals_1_TaskOutput> saveTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Approvals_1_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)Approvals_1_TaskOutput.fromMap((Map)((Map)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateContent((KogitoWorkItem)wi, (MapOutput)model), Policies.of((String)user, (Collection)groups)))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/firstLineApproval/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> completeTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Approvals_1_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/firstLineApproval/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Comment comment = (Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addComment((KogitoWorkItem)wi, (String)commentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/approvals/{id}/firstLineApproval/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId()}).toUri()).body((Object)comment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/firstLineApproval/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> updateComment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateComment((KogitoWorkItem)wi, (Object)commentId, (String)comment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/firstLineApproval/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteComment((KogitoWorkItem)wi, (Object)commentId, (String)user), Policies.of((String)user, (Collection)groups));
            return removed ? ResponseEntity.ok().build() : ResponseEntity.notFound().build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/firstLineApproval/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Attachment attachment = (Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addAttachment((KogitoWorkItem)wi, (AttachmentInfo)attachmentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/approvals/{id}/firstLineApproval/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body((Object)attachment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/firstLineApproval/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> updateAttachment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateAttachment((KogitoWorkItem)wi, (Object)attachmentId, (AttachmentInfo)attachment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/firstLineApproval/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteAttachment((KogitoWorkItem)wi, (Object)attachmentId, (String)user), Policies.of((String)user, (Collection)groups));
            return (removed ? ResponseEntity.ok() : ResponseEntity.notFound()).build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public ResponseEntity<Attachment> getAttachment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Attachment attachment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (attachment = (Attachment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().get(attachmentId)) != null) {
            return ResponseEntity.ok((Object)attachment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/attachments"}, produces={"application/json"})
    public ResponseEntity<Collection<Attachment>> getAttachments_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public ResponseEntity<Comment> getComment_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Comment comment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (comment = (Comment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().get(commentId)) != null) {
            return ResponseEntity.ok((Object)comment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/comments"}, produces={"application/json"})
    public ResponseEntity<Collection<Comment>> getComments_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}"}, produces={"application/json"})
    public ResponseEntity<Approvals_1_TaskInput> getTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Approvals_1_TaskInput.from((WorkItem)pi.workItem(taskId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"firstLineApproval/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_firstLineApproval_0() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"firstLineApproval");
    }

    @GetMapping(value={"/{id}/firstLineApproval/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)taskId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"firstLineApproval"));
    }

    @DeleteMapping(value={"/{id}/firstLineApproval/{taskId}"}, produces={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> abortTask_firstLineApproval_0(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/secondLineApproval/{taskId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> taskTransition_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="complete") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Approvals_2_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/secondLineApproval/{taskId}"}, consumes={"application/json"})
    public ResponseEntity<Approvals_2_TaskOutput> saveTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody(required=false) Approvals_2_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)Approvals_2_TaskOutput.fromMap((Map)((Map)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateContent((KogitoWorkItem)wi, (MapOutput)model), Policies.of((String)user, (Collection)groups)))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/secondLineApproval/{taskId}/phases/{phase}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> completeTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="phase") String phase, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups, @RequestBody(required=false) Approvals_2_TaskOutput model) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withModel((String)phase, (MapOutput)model, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/secondLineApproval/{taskId}/comments"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> addComment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String commentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Comment comment = (Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addComment((KogitoWorkItem)wi, (String)commentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/approvals/{id}/secondLineApproval/{taskId}/comments/{commentId}").buildAndExpand(new Object[]{id, taskId, comment.getId()}).toUri()).body((Object)comment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/secondLineApproval/{taskId}/comments/{commentId}"}, produces={"application/json"}, consumes={"text/plain"})
    public ResponseEntity<Comment> updateComment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody String comment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Comment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateComment((KogitoWorkItem)wi, (Object)commentId, (String)comment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/secondLineApproval/{taskId}/comments/{commentId}"})
    public ResponseEntity deleteComment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteComment((KogitoWorkItem)wi, (Object)commentId, (String)user), Policies.of((String)user, (Collection)groups));
            return removed ? ResponseEntity.ok().build() : ResponseEntity.notFound().build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PostMapping(value={"/{id}/secondLineApproval/{taskId}/attachments"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> addAttachment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachmentInfo, UriComponentsBuilder uriComponentsBuilder) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            Attachment attachment = (Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.addAttachment((KogitoWorkItem)wi, (AttachmentInfo)attachmentInfo, (String)user), Policies.of((String)user, (Collection)groups));
            return ResponseEntity.created((URI)uriComponentsBuilder.path("/approvals/{id}/secondLineApproval/{taskId}/attachments/{attachmentId}").buildAndExpand(new Object[]{id, taskId, attachment.getId()}).toUri()).body((Object)attachment);
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @PutMapping(value={"/{id}/secondLineApproval/{taskId}/attachments/{attachmentId}"}, produces={"application/json"}, consumes={"application/json"})
    public ResponseEntity<Attachment> updateAttachment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups, @RequestBody AttachmentInfo attachment) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> ResponseEntity.ok((Object)((Attachment)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.updateAttachment((KogitoWorkItem)wi, (Object)attachmentId, (AttachmentInfo)attachment, (String)user), Policies.of((String)user, (Collection)groups))))).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @DeleteMapping(value={"/{id}/secondLineApproval/{taskId}/attachments/{attachmentId}"})
    public ResponseEntity deleteAttachment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            boolean removed = (Boolean)pi.updateWorkItem(taskId, wi -> HumanTaskHelper.deleteAttachment((KogitoWorkItem)wi, (Object)attachmentId, (String)user), Policies.of((String)user, (Collection)groups));
            return (removed ? ResponseEntity.ok() : ResponseEntity.notFound()).build();
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/attachments/{attachmentId}"}, produces={"application/json"})
    public ResponseEntity<Attachment> getAttachment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="attachmentId") String attachmentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Attachment attachment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (attachment = (Attachment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().get(attachmentId)) != null) {
            return ResponseEntity.ok((Object)attachment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/attachments"}, produces={"application/json"})
    public ResponseEntity<Collection<Attachment>> getAttachments_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user") String user, @RequestParam(value="group") List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getAttachments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/comments/{commentId}"}, produces={"application/json"})
    public ResponseEntity<Comment> getComment_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @PathVariable(value="commentId") String commentId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Comment comment;
        Optional pi = this.process.instances().findById(id);
        if (pi.isPresent() && (comment = (Comment)HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().get(commentId)) != null) {
            return ResponseEntity.ok((Object)comment);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/comments"}, produces={"application/json"})
    public ResponseEntity<Collection<Comment>> getComments_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        Optional pi = this.process.instances().findById(id);
        return pi.isPresent() ? ResponseEntity.ok(HumanTaskHelper.findTask((ProcessInstance)((ProcessInstance)pi.get()), (String)taskId, (Policy[])Policies.of((String)user, groups)).getComments().values()) : ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}"}, produces={"application/json"})
    public ResponseEntity<Approvals_2_TaskInput> getTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return this.process.instances().findById(id).map(pi -> Approvals_2_TaskInput.from((WorkItem)pi.workItem(taskId, Policies.of((String)user, (Collection)groups)))).map(m -> ResponseEntity.ok((Object)m)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @GetMapping(value={"secondLineApproval/schema"}, produces={"application/json"})
    public Map<String, Object> getSchema_secondLineApproval_1() {
        return JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"secondLineApproval");
    }

    @GetMapping(value={"/{id}/secondLineApproval/{taskId}/schema"}, produces={"application/json"})
    public Map<String, Object> getSchemaAndPhases_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return JsonSchemaUtil.addPhases((Process)this.process, (Application)this.application, (String)id, (String)taskId, (Policy[])Policies.of((String)user, groups), (Map)JsonSchemaUtil.load((ClassLoader)this.getClass().getClassLoader(), (String)this.process.id(), (String)"secondLineApproval"));
    }

    @DeleteMapping(value={"/{id}/secondLineApproval/{taskId}"}, produces={"application/json"})
    public ResponseEntity<ApprovalsModelOutput> abortTask_secondLineApproval_1(@PathVariable(value="id") String id, @PathVariable(value="taskId") String taskId, @RequestParam(value="phase", required=false, defaultValue="abort") String phase, @RequestParam(value="user", required=false) String user, @RequestParam(value="group", required=false) List<String> groups) {
        return (ResponseEntity)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> this.process.instances().findById(id).map(pi -> {
            pi.transitionWorkItem(taskId, (Transition)HumanTaskTransition.withoutModel((String)phase, (Policy[])Policies.of((String)user, (Collection)groups)));
            return ResponseEntity.ok((Object)((ApprovalsModel)pi.checkError().variables()).toOutput());
        }).orElseGet(() -> ResponseEntity.notFound().build()));
    }
}

