/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.serverless.examples;

import com.fasterxml.jackson.databind.JsonNode;
import io.cloudevents.json.Json;
import io.cloudevents.v1.CloudEventBuilder;
import io.cloudevents.v1.CloudEventImpl;
import java.net.URI;
import java.util.Random;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;

@Path(value="/newapplicant")
public class ApplicantResource {
    Random rand = new Random();
    @Inject
    @Channel(value="out-applicants")
    Emitter<String> newApplicantEmitter;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public void submitApplicant(JsonNode newApplicant) {
        CloudEventImpl applicantEvent = CloudEventBuilder.builder().withId(UUID.randomUUID().toString()).withType("newApplicantEvent").withSource(URI.create("http://localhost:8080")).withData((Object)newApplicant).build();
        this.newApplicantEmitter.send((Object)Json.encode((Object)applicantEvent));
    }
}

