/*
 * Decompiled with CFR 0.152.
 */
package org.kogito.serverless.examples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.jackson.JsonFormat;
import java.net.URI;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/newapplicant")
public class ApplicantResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicantResource.class);
    @Inject
    ObjectMapper mapper;
    @Inject
    @Channel(value="out-applicants")
    Emitter<String> newApplicantEmitter;

    @PostConstruct
    public void init() {
        this.mapper.registerModule((Module)JsonFormat.getCloudEventJacksonModule());
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public void submitApplicant(JsonNode newApplicant) {
        try {
            CloudEvent applicantEvent = ((io.cloudevents.core.v1.CloudEventBuilder)CloudEventBuilder.v1().withId(UUID.randomUUID().toString()).withType("newApplicantEvent").withSource(URI.create("http://localhost:8080")).withData(this.mapper.writeValueAsString((Object)newApplicant).getBytes())).build();
            this.newApplicantEmitter.send((Object)this.mapper.writeValueAsString((Object)applicantEvent));
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Unable to process cloud event", (Throwable)e);
            throw new InternalServerErrorException("Unable to write cloud event data", (Throwable)e);
        }
    }
}

