/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.file;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.core.file.AsyncFile.class)
public class AsyncFile
implements ReadStream<Buffer>,
WriteStream<Buffer> {
    public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg<AsyncFile>(obj -> new AsyncFile((io.vertx.core.file.AsyncFile)obj), AsyncFile::getDelegate);
    private final io.vertx.core.file.AsyncFile delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg<Buffer>(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private WriteStreamSubscriber<Buffer> subscriber;
    private Multi<Buffer> multi;

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    AsyncFile() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.file.AsyncFile getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFile that = (AsyncFile)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    private void __end(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.end(data.getDelegate(), handler);
    }

    @Override
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__end(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return this.end(data).await().indefinitely();
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    private void __pipeTo(WriteStream<Buffer> dst, Handler<AsyncResult<Void>> handler) {
        this.delegate.pipeTo(dst.getDelegate(), handler);
    }

    @Override
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.__pipeTo(dst, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return this.pipeTo(dst).await().indefinitely();
    }

    private AsyncFile __handler(final Handler<Buffer> handler) {
        this.delegate.handler((Handler)new Handler<io.vertx.core.buffer.Buffer>(){

            @Override
            public void handle(io.vertx.core.buffer.Buffer event) {
                handler.handle(Buffer.newInstance(event));
            }
        });
        return this;
    }

    public AsyncFile handler(Consumer<Buffer> handler) {
        return this.__handler(handler != null ? handler::accept : null);
    }

    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    private AsyncFile __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    public AsyncFile endHandler(Consumer<Void> endHandler) {
        return this.__endHandler(endHandler != null ? endHandler::accept : null);
    }

    private AsyncFile __write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(data.getDelegate(), handler);
        return this;
    }

    @Override
    public Uni<Void> write(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.__write(data, (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(Buffer data) {
        return this.write(data).await().indefinitely();
    }

    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    private AsyncFile __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    public AsyncFile drainHandler(Consumer<Void> handler) {
        return this.__drainHandler(handler != null ? handler::accept : null);
    }

    private AsyncFile __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler(handler != null ? handler::accept : null);
    }

    public AsyncFile fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    private void __end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    @Override
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.__end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait() {
        return this.end().await().indefinitely();
    }

    private void __close(Handler<AsyncResult<Void>> handler) {
        this.delegate.close(handler);
    }

    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.__close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    private AsyncFile __write(Buffer buffer, long position, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(buffer.getDelegate(), position, handler);
        return this;
    }

    public Uni<Void> write(Buffer buffer, long position) {
        return AsyncResultUni.toUni(handler -> this.__write(buffer, position, (Handler<AsyncResult<Void>>)handler));
    }

    public Void writeAndAwait(Buffer buffer, long position) {
        return this.write(buffer, position).await().indefinitely();
    }

    private AsyncFile __read(Buffer buffer, int offset, long position, int length, final Handler<AsyncResult<Buffer>> handler) {
        this.delegate.read(buffer.getDelegate(), offset, position, length, new Handler<AsyncResult<io.vertx.core.buffer.Buffer>>(){

            @Override
            public void handle(AsyncResult<io.vertx.core.buffer.Buffer> ar) {
                if (ar.succeeded()) {
                    handler.handle(Future.succeededFuture(Buffer.newInstance(ar.result())));
                } else {
                    handler.handle(Future.failedFuture(ar.cause()));
                }
            }
        });
        return this;
    }

    public Uni<Buffer> read(Buffer buffer, int offset, long position, int length) {
        return AsyncResultUni.toUni(handler -> this.__read(buffer, offset, position, length, (Handler<AsyncResult<Buffer>>)handler));
    }

    public Buffer readAndAwait(Buffer buffer, int offset, long position, int length) {
        return this.read(buffer, offset, position, length).await().indefinitely();
    }

    private AsyncFile __flush(Handler<AsyncResult<Void>> handler) {
        this.delegate.flush(handler);
        return this;
    }

    public Uni<Void> flush() {
        return AsyncResultUni.toUni(handler -> this.__flush((Handler<AsyncResult<Void>>)handler));
    }

    public Void flushAndAwait() {
        return this.flush().await().indefinitely();
    }

    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    public AsyncFile setReadLength(long readLength) {
        this.delegate.setReadLength(readLength);
        return this;
    }

    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public long getWritePos() {
        long ret = this.delegate.getWritePos();
        return ret;
    }

    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    public void endAndForget(Buffer data) {
        this.delegate.end(data.getDelegate());
    }

    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.delegate.pipeTo(dst.getDelegate());
    }

    public AsyncFile writeAndForget(Buffer data) {
        this.delegate.write(data.getDelegate());
        return this;
    }

    public void endAndForget() {
        this.delegate.end();
    }

    public void closeAndForget() {
        this.delegate.close();
    }

    public AsyncFile flushAndForget() {
        this.delegate.flush();
        return this;
    }

    @Override
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti(this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

