/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.ProfileConfigSourceInterceptor;

class QuarkusProfileConfigSourceInterceptor
extends ProfileConfigSourceInterceptor {
    private final String profile;

    public QuarkusProfileConfigSourceInterceptor(String profile) {
        super(profile);
        this.profile = profile;
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        if (this.profile != null) {
            String normalizeName = this.normalizeName(name);
            ConfigValue profileValue = context.proceed("%" + this.profile + "." + normalizeName);
            if (profileValue != null) {
                return profileValue.withName(normalizeName);
            }
        }
        return context.proceed(name);
    }

    private String normalizeName(String name) {
        return name.startsWith("%" + this.profile + ".") ? name.substring(this.profile.length() + 2) : name;
    }
}

