/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.devmode;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.RemoteDevState;
import io.quarkus.runtime.ExecutorRecorder;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import java.util.Set;
import org.jboss.logging.Logger;

public class RemoteSyncHandler
implements Handler<HttpServerRequest> {
    public static final String QUARKUS_PASSWORD = "X-Quarkus-Password";
    private static final Logger log = Logger.getLogger(RemoteSyncHandler.class);
    public static final String APPLICATION_QUARKUS = "application/quarkus-live-reload";
    public static final String QUARKUS_SESSION = "X-Quarkus-Session";
    public static final String CONNECT = "/connect";
    public static final String DEV = "/dev";
    final String password;
    final Handler<HttpServerRequest> next;
    final HotReplacementContext hotReplacementContext;
    static volatile String currentSession;
    static volatile long currentSessionTimeout;
    static volatile Throwable remoteProblem;
    static boolean checkForChanges;

    public RemoteSyncHandler(String password, Handler<HttpServerRequest> next, HotReplacementContext hotReplacementContext) {
        this.password = password;
        this.next = next;
        this.hotReplacementContext = hotReplacementContext;
        hotReplacementContext.addPreScanStep(new Runnable(){

            @Override
            public void run() {
                if (currentSession == null) {
                    return;
                }
                RemoteSyncHandler.this.doPreScan();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPreScan() {
        Class<RemoteSyncHandler> clazz = RemoteSyncHandler.class;
        synchronized (RemoteSyncHandler.class) {
            checkForChanges = true;
            RemoteSyncHandler.class.notifyAll();
            try {
                RemoteSyncHandler.class.wait(30000L);
            }
            catch (InterruptedException e) {
                log.error((Object)"interrupted", e);
            }
            return;
        }
    }

    @Override
    public void handle(final HttpServerRequest event) {
        String type;
        long time = System.currentTimeMillis();
        if (time > currentSessionTimeout) {
            currentSession = null;
        }
        if (APPLICATION_QUARKUS.equals(type = event.headers().get(HttpHeaderNames.CONTENT_TYPE))) {
            String rp = event.headers().get(QUARKUS_PASSWORD);
            if (!this.password.equals(rp)) {
                log.error("Incorrect password");
                event.response().setStatusCode(401).end();
                return;
            }
            currentSessionTimeout = time + 60000L;
            ExecutorRecorder.getCurrent().execute(new Runnable(){

                @Override
                public void run() {
                    RemoteSyncHandler.this.handleRequest(event);
                }
            });
            return;
        }
        this.next.handle(event);
    }

    private void handleRequest(HttpServerRequest event) {
        if (event.method().equals((Object)HttpMethod.PUT)) {
            this.handlePut(event);
        } else if (event.method().equals((Object)HttpMethod.DELETE)) {
            this.handleDelete(event);
        } else if (event.method().equals((Object)HttpMethod.POST)) {
            if (event.path().equals(DEV)) {
                this.handleDev(event);
            } else if (event.path().equals(CONNECT)) {
                this.handleConnect(event);
            } else {
                event.response().setStatusCode(404).end();
            }
        } else {
            event.response().setStatusCode(404).end();
        }
    }

    private void handleDev(final HttpServerRequest event) {
        if (this.checkSession(event)) {
            return;
        }
        event.bodyHandler(new Handler<Buffer>(){

            @Override
            public void handle(final Buffer b) {
                ExecutorRecorder.getCurrent().execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Throwable problem = (Throwable)new ObjectInputStream(new ByteArrayInputStream(b.getBytes())).readObject();
                            if (problem != null || remoteProblem != null) {
                                remoteProblem = problem;
                                RemoteSyncHandler.this.hotReplacementContext.setRemoteProblem(problem);
                            }
                            Class<RemoteSyncHandler> clazz = RemoteSyncHandler.class;
                            synchronized (RemoteSyncHandler.class) {
                                RemoteSyncHandler.class.notifyAll();
                                RemoteSyncHandler.class.wait(10000L);
                                if (checkForChanges) {
                                    checkForChanges = false;
                                    event.response().setStatusCode(200);
                                } else {
                                    event.response().setStatusCode(204);
                                }
                                event.response().end();
                                // ** MonitorExit[var2_3] (shouldn't be in output)
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)"Connect failed", e);
                            event.response().setStatusCode(500).end();
                        }
                        {
                            return;
                        }
                    }
                });
            }
        }).exceptionHandler((Handler)new Handler<Throwable>(){

            @Override
            public void handle(Throwable t) {
                log.error((Object)"dev request failed", t);
                event.response().setStatusCode(500).end();
            }
        }).resume();
    }

    private void handleConnect(final HttpServerRequest event) {
        event.bodyHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer b) {
                try {
                    SecureRandom r = new SecureRandom();
                    byte[] sessionId = new byte[20];
                    r.nextBytes(sessionId);
                    currentSession = Base64.getEncoder().encodeToString(sessionId);
                    RemoteDevState state = (RemoteDevState)new ObjectInputStream(new ByteArrayInputStream(b.getBytes())).readObject();
                    remoteProblem = state.getAugmentProblem();
                    if (state.getAugmentProblem() != null) {
                        RemoteSyncHandler.this.hotReplacementContext.setRemoteProblem(state.getAugmentProblem());
                    }
                    Set<String> files = RemoteSyncHandler.this.hotReplacementContext.syncState(state.getFileHashes());
                    event.response().headers().set(RemoteSyncHandler.QUARKUS_SESSION, currentSession);
                    event.response().end(String.join((CharSequence)";", files));
                }
                catch (Exception e) {
                    log.error((Object)"Connect failed", e);
                    event.response().setStatusCode(500).end();
                }
            }
        }).exceptionHandler((Handler)new Handler<Throwable>(){

            @Override
            public void handle(Throwable t) {
                log.error((Object)"Connect failed", t);
                event.response().setStatusCode(500).end();
            }
        }).resume();
    }

    private void handlePut(final HttpServerRequest event) {
        if (this.checkSession(event)) {
            return;
        }
        event.bodyHandler(new Handler<Buffer>(){

            @Override
            public void handle(Buffer buffer) {
                RemoteSyncHandler.this.hotReplacementContext.updateFile(event.path(), buffer.getBytes());
                event.response().end();
            }
        }).exceptionHandler((Handler)new Handler<Throwable>(){

            @Override
            public void handle(Throwable error) {
                log.error((Object)"Failed writing hot replacement data", error);
                event.response().setStatusCode(500);
                event.response().end();
            }
        }).resume();
    }

    private void handleDelete(HttpServerRequest event) {
        if (this.checkSession(event)) {
            return;
        }
        this.hotReplacementContext.updateFile(event.path(), null);
        event.response().end();
    }

    private boolean checkSession(HttpServerRequest event) {
        String ses = event.headers().get(QUARKUS_SESSION);
        if (!Objects.equals(ses, currentSession)) {
            log.error("Invalid session");
            event.response().setStatusCode(203).end();
            return true;
        }
        return false;
    }
}

