/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.EmptyUniSubscription;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.UniDelegatingSubscriber;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.reactivestreams.Subscription;

public class UniOnItemFlatMap<I, O>
extends UniOperator<I, O> {
    private final Function<? super I, ? extends Uni<? extends O>> mapper;

    public UniOnItemFlatMap(Uni<I> upstream, Function<? super I, ? extends Uni<? extends O>> mapper) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.mapper = ParameterValidation.nonNull(mapper, "mapper");
    }

    public static <I, O> void invokeAndSubstitute(Function<? super I, ? extends Uni<? extends O>> mapper, I input, UniSerializedSubscriber<? super O> subscriber, FlatMapSubscription flatMapSubscription) {
        Uni<? extends O> outcome;
        try {
            outcome = mapper.apply(input);
        }
        catch (Throwable e) {
            if (input instanceof Throwable) {
                subscriber.onFailure(new CompositeException((Throwable)input, e));
            } else {
                subscriber.onFailure(e);
            }
            return;
        }
        UniOnItemFlatMap.handleInnerSubscription(subscriber, flatMapSubscription, outcome);
    }

    public static <O> void handleInnerSubscription(UniSerializedSubscriber<? super O> subscriber, final FlatMapSubscription flatMapSubscription, Uni<? extends O> outcome) {
        if (outcome == null) {
            subscriber.onFailure(new NullPointerException("The mapper returned `null`"));
        } else {
            UniDelegatingSubscriber delegate = new UniDelegatingSubscriber<O, O>(subscriber){

                @Override
                public void onSubscribe(UniSubscription secondSubscription) {
                    flatMapSubscription.replace(secondSubscription);
                }
            };
            outcome.subscribe().withSubscriber(delegate);
        }
    }

    @Override
    protected void subscribing(final UniSerializedSubscriber<? super O> subscriber) {
        final FlatMapSubscription flatMapSubscription = new FlatMapSubscription();
        this.upstream().subscribe().withSubscriber(new UniDelegatingSubscriber<I, O>(subscriber){

            @Override
            public void onSubscribe(UniSubscription subscription) {
                flatMapSubscription.setInitialUpstream(subscription);
                subscriber.onSubscribe(flatMapSubscription);
            }

            @Override
            public void onItem(I item) {
                UniOnItemFlatMap.invokeAndSubstitute(UniOnItemFlatMap.this.mapper, item, subscriber, flatMapSubscription);
            }
        });
    }

    protected static class FlatMapSubscription
    implements UniSubscription {
        private final AtomicReference<Subscription> upstream = new AtomicReference();

        protected FlatMapSubscription() {
        }

        @Override
        public void cancel() {
            Subscription previous = this.upstream.getAndSet(EmptyUniSubscription.CANCELLED);
            if (previous != null) {
                previous.cancel();
            }
        }

        void setInitialUpstream(Subscription up) {
            if (!this.upstream.compareAndSet(null, up)) {
                throw new IllegalStateException("Invalid upstream Subscription state, was expected none but got one");
            }
        }

        void replace(Subscription up) {
            Subscription previous = this.upstream.getAndSet(up);
            if (previous == null) {
                throw new IllegalStateException("Invalid upstream Subscription state, was expected one but got none");
            }
            if (previous == EmptyUniSubscription.CANCELLED) {
                this.upstream.set(null);
                up.cancel();
            }
        }
    }
}

